/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestNavigatorProvider.java,v 1.14 2005/04/20 15:24:18 dguilbaud Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.model.ui;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.hyades.test.ui.IHyadesTestNavigatorConverter;
import org.eclipse.hyades.test.ui.IHyadesTestNavigatorFilter;
import org.eclipse.hyades.test.ui.IHyadesTestNavigatorProvider;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.FileFactoryManager;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.FileProxyManager;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.IWorkbenchAdapter;

/**
 * @author jgout
 */
public class TestNavigatorProvider implements ITreeContentProvider, ILabelProvider, ILabelProviderListener {

	/**
	 * @deprecated
	 */
	private Map visibleElementFromFile;
	/**
	 * @deprecated
	 */
	private Map visibleElementFromObject;
	//- map to store association between file and its converted object
	/**
	 * @deprecated
	 */
	private Map convertedObjects;
	private List filters;
	private List listeners;

	/**
	 * @deprecated
	 * @author jgout
	 */
	class fileExtensionElement {
		private IHyadesTestNavigatorProvider provider;
		private IHyadesTestNavigatorConverter converter;

		public fileExtensionElement(IHyadesTestNavigatorProvider provider, IHyadesTestNavigatorConverter converter) {
			this.provider = provider;
			this.converter = converter;
		}

		public IHyadesTestNavigatorConverter getConverter() {
			return converter;
		}

		public IHyadesTestNavigatorProvider getProvider() {
			return provider;
		}
	}

	public TestNavigatorProvider() {
		visibleElementFromFile = new HashMap();
		visibleElementFromObject = new HashMap();
		convertedObjects = new HashMap();
		listeners = new LinkedList();
		filters = new LinkedList();
	}

	/**
	 * @param extName
	 * @param provider
	 * @deprecated
	 */
	public void addVisibleFile(String extName, IHyadesTestNavigatorProvider provider, IHyadesTestNavigatorConverter converter) {
		//- remove '.' (dot) character if found
		if (extName.startsWith(".")) //$NON-NLS-1$
			extName = extName.substring(1);
		if (visibleElementFromFile.containsKey(extName)) {
			TestUIPlugin.logInfo(
				"Extension file: '." + extName + "' can't be registered as a visible element in the Test Navigator due to a previous registration by another plug-in");//$NON-NLS-1$ //$NON-NLS-2$
			return;
		}
		//- register core provider as delegated provider change listener
		if(provider != null) provider.addListener(this);
		//- save data in the global map
		visibleElementFromFile.put(extName, new fileExtensionElement(provider, converter));
	}

	/**
	 * @param objectName
	 * @param provider
	 * @deprecated
	 */
	public void addVisibleObject(String objectName, IHyadesTestNavigatorProvider provider) {
		if (visibleElementFromObject.containsKey(objectName)) {
			TestUIPlugin.logInfo(
				"Extension file: '." + objectName + "' can't be registered as a visible element in the Test Navigator due to a previous registration by another plug-in");//$NON-NLS-1$ //$NON-NLS-2$
			return;
		}
		visibleElementFromObject.put(objectName, provider);
		//- register core provider as delegated provider change listener
		provider.addListener(this);
	}

	/**
	 * @param filter
	 */
	public void addFilter(IHyadesTestNavigatorFilter filter) {
		filters.add(filter);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.ITreeContentProvider#getParent(java.lang.Object)
	 */
	public Object getParent(Object element) {
		if (element instanceof IResource) {
			return ((IResource) element).getParent();
		} if (element instanceof IProxyNode) {
			return ((IProxyNode) element).getParent();
		} else if (element instanceof IProxyNode) {
			IProxyNode proxy = (IProxyNode) element;
			return proxy.getParent();
		} else {
			IHyadesTestNavigatorProvider provider = (IHyadesTestNavigatorProvider) visibleElementFromObject.get(element.getClass().getName());
			if (provider != null)
				return provider.getParent(element);
		}
		return null;
	}

	private IHyadesTestNavigatorProvider getProviderFromFile(IFile file) {
		String fileExtension = file.getFileExtension();
		if (fileExtension != null) {
			fileExtensionElement fileExt = (fileExtensionElement) visibleElementFromFile.get(fileExtension);
			if(fileExt != null) return fileExt.getProvider();
		}
		return null;
	}

	/**
	 * 
	 * @param file
	 * @return
	 * @deprecated
	 */
	public IHyadesTestNavigatorConverter getConverterFromFile(IFile file) {
		String fileExtension = file.getFileExtension();
		if (fileExtension != null) {
			fileExtensionElement fileExt = (fileExtensionElement) visibleElementFromFile.get(fileExtension);
			if(fileExt != null) return fileExt.getConverter();
		}
		return null;
	}

	/**
	 * 
	 * @param object
	 * @return
	 * @deprecated
	 */
	private IHyadesTestNavigatorProvider getProviderFromObject(Object object) {
		return (IHyadesTestNavigatorProvider) visibleElementFromObject.get(object);
	}

	private boolean filter(Object element) {
		if(element == null) return true;
		for (Iterator it = filters.iterator(); it.hasNext();) {
			IHyadesTestNavigatorFilter filter = (IHyadesTestNavigatorFilter) it.next();
			if (filter.isFiltered(element))
				return true;
		}
		return false;
	}

	private Object[] filterChildren(Object[] children) {
		if (children == null)
			return new Object[0];

		LinkedList res = new LinkedList();
		for (int i = 0; i < children.length; i++) {
			if (!filter(children[i]))
				res.add(children[i]);
		}
		return res.toArray();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.ITreeContentProvider#hasChildren(java.lang.Object)
	 */
	public boolean hasChildren(Object parentElement) {
		if (parentElement == null)
			return false;
		if (parentElement instanceof IContainer) {
			IContainer container = (IContainer) parentElement;
			if (!container.exists())
				return false;

			IResource[] resources = null;
			try {
				resources = container.members();
			} catch (CoreException e) {
				TestUIPlugin.logError(e);
				return false;
			}
			for (int i = 0; i < resources.length; i++) {
				if (resources[i].getType() != IResource.FILE) {
					if (!filter(resources[i]))
						return true;
				} else {
					String fileExtension = resources[i].getFileExtension();
					if (fileExtension != null) {
						if (isVisibleResource(resources[i])) return true;
					}
				}
			}
			return false;
		} else if (parentElement instanceof IFile) {
			//- delagating for declared files
			IFile res = (IFile) parentElement;
			IHyadesTestNavigatorProvider provider = getProviderFromFile(res);
			if (provider != null)
				return filterChildren(provider.getChildren(res)).length > 0;
		} else if (parentElement instanceof IProxyNode) {
			IProxyNode proxy = (IProxyNode) parentElement;
			return proxy.getChildren().length > 0;
		} else {
			//- delegating for declared objects
			IHyadesTestNavigatorProvider provider = (IHyadesTestNavigatorProvider) visibleElementFromObject.get(parentElement.getClass().getName());
			if (provider != null)
				return filterChildren(provider.getChildren(parentElement)).length > 0;
		}
		return false;
	}

	/** Returns whether the given resource is visible in the test navigator (not filtered and handles).
	 * @param resource the resrouce to test.
	 * @return true if the resource is not filtered and handled by the navigator, false otherwise.
	 */
	public boolean isVisibleResource(IResource resource) {
		if(resource.getType() != IResource.FILE) {
			return !filter(resource);
		} else {
			String fileExtension = resource.getFileExtension();
			if (fileExtension != null) {
				return FileFactoryManager.getInstance().isRegistered(fileExtension) && !filter(resource);
			}
			return false;
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.ITreeContentProvider#getChildren(java.lang.Object)
	 */
	public Object[] getChildren(Object parentElement) {
		if (parentElement instanceof IContainer) {
			return getContainerChildren(parentElement);
		} else if (parentElement instanceof IFile) {
			IFile res = (IFile) parentElement;
			IHyadesTestNavigatorProvider provider = getProviderFromFile(res);
			if (provider != null)
				return filterChildren(provider.getChildren(res));
		} else if (parentElement instanceof IProxyNode) {
			IProxyNode proxy = (IProxyNode) parentElement;
			return proxy.getChildren();
		} else {
			IHyadesTestNavigatorProvider provider = (IHyadesTestNavigatorProvider) visibleElementFromObject.get(parentElement.getClass().getName());
			if (provider != null)
				return filterChildren(provider.getChildren(parentElement));
		}
		return new Object[0];
	}
	
	/** returns the children of a container node (project or folder)
	 * @param parentElement
	 * @return an array of Object which cn be empty but not null
	 */
	private Object[] getContainerChildren(Object parentElement) {
		List children = new UniqueEList();
		IResource[] resources = null;
		try {
			resources = ((IContainer) parentElement).members();
		} catch (CoreException e) {
			TestUIPlugin.logError(e);
			return new Object[0];
		}

		for (int i = 0, maxi = resources.length; i < maxi; i++) {
			if(!filter(resources[i])) {
				if (resources[i].getType() != IResource.FILE) {
					//- folders are displayed as they are
					children.add(resources[i]);
				} else {
					//- convert the file in something (proxy)
					Object node = getFileNode((IFile)resources[i]);
					if(!filter(node)) {
						children.add(node);
					}
				}
			}
		}
		return children.toArray();
	}

	/** Get the node associated to the given file
	 * 
	 * @param file
	 * @return the proxy node from the given file
	 */
	private Object getFileNode(IFile file) {
		Object node = null;
		//- ask to the file proxy manager the proxy corresponding to this file 
		node = FileProxyManager.getInstance().getProxy(file);
		if (node == null) {
			//- compatibility with old extension points. this code should be removed in future
			//- lookup first provider for this file
			IHyadesTestNavigatorProvider provider = getProviderFromFile(file);
			if (provider != null) {
				node = file;
			} else {
				//- if no provider provided it should have a converter
				IHyadesTestNavigatorConverter converter = getConverterFromFile(file);
				if (converter != null) {
					node = converter.getObjectFromResource(file);
					//- this object would be filtered ... test it
					if (!filter(node)) {
						addCorrespondingObjectFromFile(file, node);
					}
				}
			}
		}
		return node;
	}

	private IWorkbenchAdapter getWorkbenchAdapter(Object object) {
		IWorkbenchAdapter workbenchAdapter = (IWorkbenchAdapter) Platform.getAdapterManager().getAdapter(object, IWorkbenchAdapter.class);
		if (workbenchAdapter == this)
			return null;

		return workbenchAdapter;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.ILabelProvider#getImage(java.lang.Object)
	 */
	public Image getImage(Object element) {
		if (element == null)
			return null;
		if (element instanceof IContainer) {
			ImageDescriptor descriptor;
			IWorkbenchAdapter workbenchAdapter = getWorkbenchAdapter(element);
			if (workbenchAdapter != null) {
				descriptor = workbenchAdapter.getImageDescriptor(element);
				if (descriptor != null)
					return descriptor.createImage();
			}
		} else if (element instanceof IFile) {
			IHyadesTestNavigatorProvider provider = getProviderFromFile((IFile) element);
			if(provider != null) {
				return provider.getImage(element);
			}
		} else if (element instanceof IProxyNode) {
			return ((IProxyNode) element).getImage();
		} else {
			//- compatibility: this code should be removed in future
			//- if not a typed element or a not overload typed element
			IHyadesTestNavigatorProvider provider = (IHyadesTestNavigatorProvider) visibleElementFromObject.get(element.getClass().getName());
			if (provider != null)
				return provider.getImage(element);
		}
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.ILabelProvider#getText(java.lang.Object)
	 */
	public String getText(Object element) {
		if (element == null)
			return ""; //$NON-NLS-1$
		if (element instanceof IContainer) {
			IWorkbenchAdapter workbenchAdapter = getWorkbenchAdapter(element);
			if (workbenchAdapter != null) {

				return workbenchAdapter.getLabel(element);
			}
		} else if (element instanceof IFile) {
			IHyadesTestNavigatorProvider provider = getProviderFromFile((IFile) element);
			if(provider != null) {
				return provider.getText(element);
			}
		} else if (element instanceof IProxyNode) {
			return ((IProxyNode) element).getText();
		} else {
			//- if not a typed element or a not overload typed element
			IHyadesTestNavigatorProvider provider = (IHyadesTestNavigatorProvider) visibleElementFromObject.get(element.getClass().getName());
			if (provider != null)
				return provider.getText(element);
		}
		return ""; //$NON-NLS-1$
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IStructuredContentProvider#getElements(java.lang.Object)
	 */
	public Object[] getElements(Object inputElement) {
		if (inputElement instanceof IWorkspaceRoot) {
			IProject [] projects = ((IWorkspaceRoot) inputElement).getProjects();
			LinkedList visibleProjects = new LinkedList();
			for(int i = 0; i < projects.length; i++) {
				if(!filter(projects[i])) {
					visibleProjects.add(projects[i]);
				}
			}
			return visibleProjects.toArray();
		}
		return getChildren(inputElement);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IBaseLabelProvider#dispose()
	 */
	public void dispose() {
//		visibleElementFromFile.clear();
//		visibleElementFromObject.clear();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IContentProvider#inputChanged(org.eclipse.jface.viewers.Viewer, java.lang.Object, java.lang.Object)
	 */
	public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IBaseLabelProvider#addListener(org.eclipse.jface.viewers.ILabelProviderListener)
	 */
	public void addListener(ILabelProviderListener listener) {
		listeners.add(listener);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IBaseLabelProvider#isLabelProperty(java.lang.Object, java.lang.String)
	 */
	public boolean isLabelProperty(Object element, String property) {
		// TODO Auto-generated method stub
		return false;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IBaseLabelProvider#removeListener(org.eclipse.jface.viewers.ILabelProviderListener)
	 */
	public void removeListener(ILabelProviderListener listener) {
		if (!listeners.remove(listener)) {
			TestUIPlugin.logInfo("Unable to remove listener '" + listener.toString()); //$NON-NLS-1$
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.ILabelProviderListener#labelProviderChanged(org.eclipse.jface.viewers.LabelProviderChangedEvent)
	 */
	public void labelProviderChanged(LabelProviderChangedEvent event) {
		for (Iterator it = listeners.iterator(); it.hasNext();) {
			ILabelProviderListener listener = (ILabelProviderListener) it.next();
			listener.labelProviderChanged(event);
		}
	}

	/** Returns the array of file extensions found in test navigator extender
	 * @return file extensions of visible files
	 * @deprecated
	 */
	public String[] getVisibleFiles() {
		Set s = visibleElementFromFile.keySet();
		String[] res = new String[s.size()];
		int i = 0;
		for (Iterator it = s.iterator(); it.hasNext(); i++) {
			res[i] = (String) it.next();
		}
		return res;
	}
	
	/**
	 * @param resource
	 * @return
	 * @deprecated
	 */
	public Object getCorrespondingObjectFromFile(IResource resource) {
		return convertedObjects.get(resource);
	}

	/**
	 * @param resource
	 * @deprecated
	 */
	public void cleanConvertedObjectEntryFor(IResource resource) {
		if(convertedObjects.containsKey(resource)){
			convertedObjects.remove(resource);
		}
	}

	/**
	 * @param resource
	 * @param convertedObject
	 * @deprecated
	 */
	public void addCorrespondingObjectFromFile(IResource resource, Object convertedObject) {
		if(resource != null && convertedObject != null) {
			convertedObjects.put(resource, convertedObject);
		}
	}

}
