/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: VisibleTypes.java,v 1.6 2005/04/22 14:51:01 bjiang Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.model.ui;

import java.util.HashMap;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.test.ui.IHyadesTestNavigatorProvider;
import org.eclipse.hyades.test.ui.TestUIPlugin;



/**
 * @author kdarcour
 * @author jcanches
 *
 * The singleton class provides the Type Providers registered in the Plug-in registry.
 * Providers are loaded on a lazy scheme. 
 * 
 */
public class VisibleTypes implements ITypeProviderFactory
{
	private static VisibleTypes theInstance = null;
	private HashMap types;
	
	public static VisibleTypes getInstance() 
	{
		if (theInstance == null) 
			theInstance = new VisibleTypes();
		return theInstance;
	}
		
	/** Returns the associated provider for the given type of element found in the HTN
	 * 
	 * @param type the type of elements (this type shoudlhas been declared through the extension point <code>org.eclipse.hyades.test.ui.testNavigatorType</code>
	 * @return a provider for the given type <code>type</code> or <code>null</code> if the type does not exist (or problem has been encountered)
	 */
	public IHyadesTestNavigatorProvider getProvider(String type) {
		IHyadesTestNavigatorProvider provider = null;
		if(types.containsKey(type)) {
			Object value = types.get(type);
			if (value instanceof IConfigurationElement) {
				//- if the provider has not yet been loaded
				IConfigurationElement element = (IConfigurationElement) value;
				try {
					provider = (IHyadesTestNavigatorProvider)element.createExecutableExtension("provider"); //$NON-NLS-1$
					types.put(type, provider);
				} catch (CoreException e) {
					provider = null;
				}
			} else {
				//- the provider has been loaded yet
				if (value instanceof IHyadesTestNavigatorProvider) {
					provider = (IHyadesTestNavigatorProvider) value;
				}
			}
		}
		return provider;
	}

	private VisibleTypes() 
	{
		types = new HashMap();
		IExtensionPoint extPoint = Platform.getExtensionRegistry().getExtensionPoint(TestUIPlugin.getID() + ".testNavigatorType"); //$NON-NLS-1$
		if (extPoint != null) 
		{
			IConfigurationElement[] members = extPoint.getConfigurationElements();
			String typeName;
			for (int i = 0; i < members.length; i++) 
			{
				if (members[i].getName() != null) 
				{
					//- get extension of files we want to make visible
					IConfigurationElement element = members[i];
					typeName = element.getAttribute("targetType"); //$NON-NLS-1$
					types.put(typeName,element);
				}
			}
		}
	}
	
}
