/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestCaseHTNProvider.java,v 1.8 2005/02/16 22:22:06 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.hyades.models.common.testprofile.TPFTestCase;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.models.common.testprofile.impl.TPFTestCaseImpl;
import org.eclipse.hyades.test.ui.IHyadesTestNavigatorProvider;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.internal.model.ui.ITypeProviderFactory;
import org.eclipse.hyades.test.ui.internal.model.ui.VisibleTypes;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;

/**
 * @author jgout
 * @author jcanches
 */
public class TestCaseHTNProvider implements IHyadesTestNavigatorProvider, IExecutableExtension {

	private ITypeProviderFactory typeProvidersFactory;
	
	public TestCaseHTNProvider() {
		// By default, use providers registered as extensions
		this.typeProvidersFactory = VisibleTypes.getInstance();
	}
	
	public TestCaseHTNProvider(ITypeProviderFactory factory) {
		this.typeProvidersFactory = factory;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IBaseLabelProvider#dispose()
	 */
	public void dispose() {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.ITreeContentProvider#getChildren(java.lang.Object)
	 */
	public Object[] getChildren(Object parentElement)  
	{
		if (parentElement instanceof TPFTestCase) 
		{
			TPFTestCase tc = (TPFTestCase) parentElement;
			IHyadesTestNavigatorProvider provider = typeProvidersFactory.getProvider(tc.getType());
			if (provider != null)
				return provider.getChildren(tc);
		}	
		//- Default Hyades behavior
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IStructuredContentProvider#getElements(java.lang.Object)
	 */
	public Object[] getElements(Object inputElement)  
	{
		if (inputElement instanceof TPFTestSuite) 
		{
			TPFTestCase tc = (TPFTestCase) inputElement;
			IHyadesTestNavigatorProvider provider = typeProvidersFactory.getProvider(tc.getType());
			if (provider != null)
				return provider.getElements(tc);
		}	
		//- Default Hyades behavior
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.ILabelProvider#getImage(java.lang.Object)
	 */
	public Image getImage(Object element)  
	{
		if (element instanceof TPFTestCaseImpl) 
		{
			TPFTestCase tc = (TPFTestCase) element;
			IHyadesTestNavigatorProvider provider = typeProvidersFactory.getProvider(tc.getType());
			if (provider != null)
				return provider.getImage(tc);
			
			//- Default Hyades behavior
			return TestUIImages.INSTANCE.getImage(TestUIImages.IMG_TEST_CASE);
		}
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.ITreeContentProvider#getParent(java.lang.Object)
	 */
	public Object getParent(Object element)  
	{
		if (element instanceof TPFTestCaseImpl) 
		{
			TPFTestCase tc = (TPFTestCase) element;
			IHyadesTestNavigatorProvider provider = typeProvidersFactory.getProvider(tc.getType());
			if (provider != null)
				return provider.getParent(tc);
			
			//- Default Hyades behavior
			TPFTestSuite ts = tc.getTestSuite();
			return ts;
		}		
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.ILabelProvider#getText(java.lang.Object)
	 */
	public String getText(Object element)  
	{
		if (element instanceof TPFTestCaseImpl) 
		{
			TPFTestCase tc = (TPFTestCase) element;

			IHyadesTestNavigatorProvider provider = typeProvidersFactory.getProvider(tc.getType());
			if (provider != null)
				return provider.getText(tc);
			
			//- Default Hyades behavior
			return tc.getName();
		}
		return ""; //$NON-NLS-1$
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.ITreeContentProvider#hasChildren(java.lang.Object)
	 */
	public boolean hasChildren(Object element)  
	{
		if (element instanceof TPFTestCaseImpl) 
		{
			TPFTestCase tc = (TPFTestCase) element;
		    IHyadesTestNavigatorProvider provider = typeProvidersFactory.getProvider(tc.getType());
		    if (provider != null)
			    return provider.hasChildren(tc);
		}
		//- Default Hyades behavior
		return false;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IContentProvider#inputChanged(org.eclipse.jface.viewers.Viewer, java.lang.Object, java.lang.Object)
	 */
	public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see org.eclipse.core.runtime.IExecutableExtension#setInitializationData(org.eclipse.core.runtime.IConfigurationElement, java.lang.String, java.lang.Object)
	 */
	public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IBaseLabelProvider#addListener(org.eclipse.jface.viewers.ILabelProviderListener)
	 */
	public void addListener(ILabelProviderListener listener) {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IBaseLabelProvider#isLabelProperty(java.lang.Object, java.lang.String)
	 */
	public boolean isLabelProperty(Object element, String property)  
	{
		if (element instanceof TPFTestCaseImpl) 
		{
			TPFTestCase tc = (TPFTestCase) element;

		    IHyadesTestNavigatorProvider provider = typeProvidersFactory.getProvider(tc.getType());
		    if (provider != null)
			    return provider.isLabelProperty(tc,property);
		}
		//- Default Hyades behavior
		// TODO Auto-generated method stub
		return false;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IBaseLabelProvider#removeListener(org.eclipse.jface.viewers.ILabelProviderListener)
	 */
	public void removeListener(ILabelProviderListener listener) {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.test.ui.IHyadesTestNavigatorProvider#getNodeObject(java.lang.Object)
	 */
	public Object getNodeObject(Object element) {
		if (element instanceof TPFTestCase) {
			return (TPFTestCase) element;
		} else return null;
	}

	/** This method returns the verdict of the passed element, in this case there is no status
	 * because this is not an execution node.
	 * @param element the element in the Test Navigator
	 * @return  IHyadesTestNavigatorProvider.VERDICT_NONE
	 */
	public int getVerdict(Object element)
	{
		if (element instanceof TPFTestCaseImpl) 
		{
			TPFTestCase tc = (TPFTestCase) element;
		    IHyadesTestNavigatorProvider provider = typeProvidersFactory.getProvider(tc.getType());
		    if (provider != null)
			    return provider.getVerdict(tc);
		}
		//- Default Hyades behavior
		return IHyadesTestNavigatorProvider.VERDICT_NONE;
	}

}
