/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestNavigatorFrameSource.java,v 1.4 2005/02/16 22:22:06 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator;

import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.ui.views.framelist.Frame;
import org.eclipse.ui.views.framelist.IFrameSource;
import org.eclipse.ui.views.framelist.TreeFrame;

import org.eclipse.hyades.models.common.common.CMNNamedElement;
import org.eclipse.hyades.ui.internal.logicalfolder.LogicalFolder;
import org.eclipse.hyades.ui.internal.navigator.TreeNavigatorFrameSource;

/**
 * Extension of the <code>TreeNavigatorFrameSource</code> customized to handle the
 * test navigator.
 * 
 * @author marcelop
 * @since 0.2.0
 */
public class TestNavigatorFrameSource 
extends TreeNavigatorFrameSource
{
	/**
	 * Constructor for TestNavigatorFrameSource
	 * @param treeNavigator
	 */
	public TestNavigatorFrameSource(TestNavigator testNavigator)
	{
		super(testNavigator);
	}

	/**
	 * @see org.eclipse.ui.views.framelist.TreeViewerFrameSource#getParentFrame(int)
	 */
	protected Frame getParentFrame(int flags)
	{
		Object input = getViewer().getInput();
		ITreeContentProvider provider = (ITreeContentProvider)getViewer().getContentProvider();
		Object parent = provider.getParent(input);
		if(parent == null) 
		{
			if((input instanceof LogicalFolder) || (input instanceof CMNNamedElement))
				parent = ((TestNavigator)getTreeNavigator()).getInitialViewerInput();
			else 
				return null;
		}

		TreeFrame frame = createFrame(parent);
		if ((flags & IFrameSource.FULL_CONTEXT) != 0) {
			frame.setSelection(getViewer().getSelection());
			// include current input in expanded set
			Object[] expanded = getViewer().getExpandedElements();
			Object[] newExpanded = new Object[expanded.length + 1];
			System.arraycopy(expanded, 0, newExpanded, 0, expanded.length);
			newExpanded[newExpanded.length - 1] = input;
			frame.setExpandedElements(newExpanded);
		}
		return frame;
	}
}
