/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestPerspectiveFactory.java,v 1.10 2005/05/15 22:57:55 bjiang Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator;

import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;

/**
 * Hyades Test UI perspective.
 * 
 * @author marcelop
 * @since 0.0.1
 */
public class TestPerspectiveFactory 
implements IPerspectiveFactory
{
	public void createInitialLayout(IPageLayout layout)
	{
		String editorArea = layout.getEditorArea();
		
		IFolderLayout left = layout.createFolder("left", IPageLayout.LEFT, 0.25f, editorArea); //$NON-NLS-1$
		left.addView(TestNavigator.ID);
// BCO		left.addView(ExecutionNavigator.ID);
		
		IFolderLayout bottonLeft = layout.createFolder("bottonLeft", IPageLayout.BOTTOM, 0.55f, "left"); //$NON-NLS-1$ //$NON-NLS-2$
		bottonLeft.addView(IPageLayout.ID_OUTLINE);
		bottonLeft.addView(IPageLayout.ID_PROP_SHEET);
		
		IFolderLayout botton = layout.createFolder("botton", IPageLayout.BOTTOM, 0.80f, editorArea); //$NON-NLS-1$
		botton.addView(IPageLayout.ID_TASK_LIST);
		
		//bugzilla_95055 - Default Test perspective has extra empty pane to the right
		//IFolderLayout right = layout.createFolder("right", IPageLayout.RIGHT, 0.65f, editorArea); //$NON-NLS-1$
		

		layout.addShowViewShortcut(TestNavigator.ID);

// BCO		layout.addShowViewShortcut(ExecutionNavigator.ID);		
		layout.addShowViewShortcut(IPageLayout.ID_TASK_LIST);
		layout.addShowViewShortcut(IPageLayout.ID_OUTLINE);
	}
}