/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ExecToggleFolderAction.java,v 1.4 2005/02/16 22:22:06 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.action;

import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.navigator.ExecutionNavigator;
import org.eclipse.hyades.test.ui.internal.util.ContextIds;
import org.eclipse.hyades.ui.internal.navigator.action.NavigatorAction;
import org.eclipse.ui.help.WorkbenchHelp;


/**
 * This action toggles whether the Hyades navigator should present the project and 
 * folders hierarchy or present the logical visualization.
 * 
 * @author marcelop
 * @since 0.0.1
 */
public class ExecToggleFolderAction 
extends NavigatorAction
{
	/**
	 * Constructor for ToggleFolderAction
	 * @param navigator
	 * @param label
	 */
	public ExecToggleFolderAction(ExecutionNavigator execNavigator, String label)
	{
		super(execNavigator, label);
		setChecked(execNavigator.isShowingFolders());
		WorkbenchHelp.setHelp(this, TestUIPlugin.getID() + ContextIds.EXEC_TOGGLEF_ACT);														
	}

	/**
	 * @see org.eclipse.jface.action.IAction#run()
	 */
	public void run()
	{
		((ExecutionNavigator)getNavigator()).setShowingFolders(isChecked());
	}
}
