/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ExecutionFilterDialog.java,v 1.6 2005/02/16 22:22:06 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.hyades.test.ui.internal.navigator.action;

import org.eclipse.hyades.test.ui.TestUI;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.navigator.ExecutionNavigator;
import org.eclipse.hyades.test.ui.internal.util.ContextIds;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.*;
import org.eclipse.ui.help.WorkbenchHelp;
class ExecutionFilterDialog
extends Dialog implements Listener
{
	private ExecutionNavigator executionExplorer;
	
	private Button okButton;
	
	private Button showRunningButton;
	private Button showFinishedButton;
	private IPreferenceStore store;

	/**
	 * Constructor for ExecutionFilterDialog
	 */
	public ExecutionFilterDialog(ExecutionNavigator executionExplorer)
	{
		super(executionExplorer.getSite().getShell());
		this.executionExplorer = executionExplorer;
		store = TestUIPlugin.getInstance().getPreferenceStore();		
	}

	/**
	 * @see Window#configureShell(Shell)
	 */
	protected void configureShell(Shell newShell)
	{
		super.configureShell(newShell);
		newShell.setText(TestUIPlugin.getString("EXEC_DLG_TITLE")); //$NON-NLS-1$
	}

	/**
	 * @see Dialog#createDialogArea(Composite)
	 */
	protected Control createDialogArea(Composite parent)
	{
		Composite composite = (Composite)super.createDialogArea(parent);
//		setMessage(TestUIPlugin.getString("EXEC_DLG_DESC"));

		createFilterOptions(composite);

		setCurrentFilter();
		adjustOptions();
		WorkbenchHelp.setHelp(composite, TestUIPlugin.getID() + ContextIds.EXEC_DLG);														
		
		return composite;
	}
	private Control createFilterOptions(Composite parent)
	{
		GridLayout layout = new GridLayout();
		layout.numColumns = 1;
		layout.horizontalSpacing = 10;
		layout.verticalSpacing = 5;
		layout.marginWidth = 10;
		layout.marginHeight = 10;
		
		Group composite = new Group(parent, SWT.NULL);
		composite.setText(TestUIPlugin.getString("EXEC_DLG_DESC")); //$NON-NLS-1$
		composite.setLayout(layout);
		GridData data = GridDataUtil.createFill();
		data.widthHint = 300;
		composite.setLayoutData(data);
		
		showRunningButton = new Button(composite, SWT.CHECK);
		showRunningButton.setText(TestUIPlugin.getString("EXEC_DLG_SHOW_RUN")); //$NON-NLS-1$
		showRunningButton.addListener(SWT.Selection, this);

		showFinishedButton = new Button(composite, SWT.CHECK);
		showFinishedButton.setText(TestUIPlugin.getString("EXEC_DLG_SHOW_FINISHED")); //$NON-NLS-1$
		showFinishedButton.addListener(SWT.Selection, this);
	
		WorkbenchHelp.setHelp(showRunningButton, TestUIPlugin.getID() + ContextIds.EXEC_SHOW_RUN_DLG);														
		WorkbenchHelp.setHelp(showFinishedButton, TestUIPlugin.getID() + ContextIds.EXEC_SHOW_END_DLG);														

		return parent;
	}
	
	private void setCurrentFilter()
	{
		int pref = store.getInt(TestUI.EXECUTION_FILTER);
		
		boolean showRunning = ((pref & ExecutionNavigator.FILTER_SHOW_RUNNING)==ExecutionNavigator.FILTER_SHOW_RUNNING);
		boolean showFinished = ((pref & ExecutionNavigator.FILTER_SHOW_FINISHED)==ExecutionNavigator.FILTER_SHOW_FINISHED);

		showRunningButton.setSelection(showRunning);
		showFinishedButton.setSelection(showFinished);
	}
	
	protected int getShowRunningFinished()
	{
		int pref = 0;
		
		if(showRunningButton.getSelection())
			pref = pref | ExecutionNavigator.FILTER_SHOW_RUNNING;

		if(showFinishedButton.getSelection())
			pref = pref | ExecutionNavigator.FILTER_SHOW_FINISHED;
		return pref;
	}

	/**
	 * @see Dialog#okPressed()
	 */
	protected void okPressed()
	{
		int pref = getShowRunningFinished();
		store.setValue(TestUI.EXECUTION_FILTER, pref);
		
		executionExplorer.getTreeViewer().refresh();
		
		super.okPressed();
	}
		
	/*
	 * @see Dialog#createButton(Composite, int, String, boolean)
	 */
	protected Button createButton(Composite parent, int id, String label, boolean defaultButton)
	{
		Button button = super.createButton(parent, id, label, defaultButton);
		if(id == IDialogConstants.OK_ID)
		{
			okButton = button;
			okButton.setEnabled(false);
		}
			
		return button;
	}
	
	/*
	 * @see Listener#handleEvent(Event)
	 */
	public void handleEvent(Event event)
	{
		if(event.type == SWT.Selection)
		{
			adjustOptions();
		}
	}
	
	/*
	 * Returns true is the selection should be removed
	 */
	private boolean adjustOptions()
	{
		int filter = getShowRunningFinished();
		if(okButton != null)
		{
			boolean enabled = (store.getInt(TestUI.EXECUTION_FILTER) != filter);
								
			okButton.setEnabled(enabled);
		}
		
		return false;
	}	
}