/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: FlieProxyInContainerPaste.java,v 1.3 2005/02/16 22:22:06 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.action;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.hyades.test.ui.navigator.FileProxyNode;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.ProxyNodeTransfer;
import org.eclipse.hyades.test.ui.navigator.actions.IPaster;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.actions.CopyFilesAndFoldersOperation;
import org.eclipse.ui.part.ResourceTransfer;

/**
 * @author jgout
 * @since 3.3
 */
public class FlieProxyInContainerPaste implements IPaster {

	private IResource [] getResourceFromClipboard(final Clipboard clipboard) {
		final IResource[][] clipboardData = new IResource[1][];
		Display.getCurrent().syncExec(new Runnable() {
			public void run() {
				//- clipboard must have resources or files
				ResourceTransfer resTransfer = ResourceTransfer.getInstance();
				clipboardData[0] = (IResource[]) clipboard.getContents(resTransfer);
			}
		});
		return clipboardData[0];
	}
	
	public boolean isPasteAllowedFor(Clipboard clipboard, Object selection) {
		if(selection instanceof IContainer) {
			ProxyNodeTransfer proxyTransfer = ProxyNodeTransfer.getInstance();
			IProxyNode [] clipContent = (IProxyNode [])clipboard.getContents(proxyTransfer);
			if(clipContent == null) {
				return false;
			}
			for (int i = 0; i < clipContent.length; i++) {
				IProxyNode proxy = clipContent[i];
				if(!(proxy instanceof FileProxyNode) && !(proxy.getParent() instanceof IContainer)) {
					return false;
				}
			}
			return true;
		}
		return false;
	}

	public boolean performPaste(Clipboard clipboard, Object selection) {
		//- check for internal copy (inside eclipse)
		IResource [] res = getResourceFromClipboard(clipboard);
		if(res != null && res.length > 0) {
			boolean doable = true;
			//- all resources stored in the clipboard should be folders/files
			for (int i = 0; i < res.length; i++) {
				doable &= res[i].getType() == IResource.FOLDER || res[i].getType() == IResource.FILE;
			}
			IResource [] copied = new IResource[0];
			if(doable) {
				CopyFilesAndFoldersOperation operation = new CopyFilesAndFoldersOperation(Display.getCurrent().getActiveShell());
				copied = operation.copyResources(res, (IContainer)selection);
			}
			return doable && copied.length > 0;
		}
		//- try a file transfer
		FileTransfer fileTransfer = FileTransfer.getInstance();
		String[] fileData = (String[])clipboard.getContents(fileTransfer);
		
		if (fileData != null) {
			CopyFilesAndFoldersOperation operation = new CopyFilesAndFoldersOperation(Display.getCurrent().getActiveShell());
			operation.copyFiles(fileData, (IContainer)selection);
			return true;
		}

		return false;
	}
}
