/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ArtifactFileProxyNode.java,v 1.4 2005/02/16 22:22:06 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.proxy;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.test.ui.TestUIConstants;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.navigator.IPersistableProxyNode;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMemento;

/**
 * @author jgout
 * @since 3.2
 */
public class ArtifactFileProxyNode extends EMFResourceProxyNode implements IPersistableProxyNode {
	
	public ArtifactFileProxyNode(IFile file, Resource res) {
		super(file, res);
	}
	
	public ArtifactFileProxyNode(IFile file, String name, IMemento [] children) {
		super(file, name, children);
	}
	
	public Image getImage() {
		return TestUIImages.INSTANCE.getImage(TestUIImages.IMG_ARTIFACT);
	}

	public String getFactoryID() {
		return "EMFResourceProxyFactory"; //$NON-NLS-1$
	}
	
	public boolean saveState(IMemento memento) {
		//- data to retrieve the correct object 
		memento.putString(TestUIConstants.TAG_NODE_KIND, TestUIConstants.ARTIFACT_FILE_NODE);
		//- data from EMFResourceProxyNode
		memento.putString(TestUIConstants.TAG_NAME, getText());
		IProxyNode [] children = getChildren();
		for (int i = 0; i < children.length; i++) {
			if(!saveChildState(memento, children[i])) {
				return false;
			}
		}
		return true;
	}
}
