/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DefaultTestCaseProxyNode.java,v 1.4 2005/02/16 22:22:06 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.proxy;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.testprofile.TPFTestCase;
import org.eclipse.hyades.test.ui.TestUIConstants;
import org.eclipse.hyades.test.ui.TestUIExtension;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.test.ui.navigator.IPersistableProxyNode;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.ITestCaseProxyNode;
import org.eclipse.hyades.test.ui.navigator.TypedElementProxyNode;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.extension.IAssociationMapping;
import org.eclipse.hyades.ui.internal.extension.AssociationMappingRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMemento;

/**
 * @author jgout
 */
public class DefaultTestCaseProxyNode extends TypedElementProxyNode implements ITestCaseProxyNode, IPersistableProxyNode {

	private IAssociationDescriptor descriptor;

	/**
	 * @param tc
	 * @param parent
	 */
	public DefaultTestCaseProxyNode(TPFTestCase tc, Object parent) {
		super(tc, parent);
		AssociationMappingRegistry registry = (AssociationMappingRegistry)TestUIExtension.getTestCaseMappingRegistry();
		IAssociationMapping associationMapping = registry.getAssociationMapping(HyadesUIPlugin.EP_TYPE_DESCRIPTIONS);
		descriptor = associationMapping.getDefaultAssociationDescriptor(tc.getType());
	}

	public DefaultTestCaseProxyNode(IMemento memento, Object parent) {
		super(memento, parent);
		AssociationMappingRegistry registry = (AssociationMappingRegistry)TestUIExtension.getTestCaseMappingRegistry();
		IAssociationMapping associationMapping = registry.getAssociationMapping(HyadesUIPlugin.EP_TYPE_DESCRIPTIONS);
		descriptor = associationMapping.getDefaultAssociationDescriptor(getType());		
	}
	
	public Image getImage() {
		if(descriptor != null) {
			return descriptor.getImage();
		} else {
			//- the type of this element wasn't registered by any extension (hyades.ui.typeDescriptions)
			return TestUIImages.INSTANCE.getImage(TestUIImages.IMG_TEST_CASE);
		}
	}

	public IProxyNode[] getChildren() {
		//- no children for a test case node
		return new IProxyNode[0];
	}
	
	public TPFTestCase getTestCase() {
		EObject tc = EMFUtil.getResourceSet().getEObject(getOriginatorURI(), true);
		if (tc instanceof TPFTestCase) {
			return (TPFTestCase) tc;
		} else {
			return null;
		}
	}
	
	public String getFactoryID() {
		return "EMFResourceProxyFactory"; //$NON-NLS-1$
	}
	
	public boolean saveState(IMemento memento) {
		//- data to retrieve the correct object 
		memento.putString(TestUIConstants.TAG_NODE_KIND, TestUIConstants.TESTCASE_NODE);
		//- data from TypedElementProxyNode
		memento.putString(TestUIConstants.TAG_TYPE, getType());
		//- data from CMNNamedElementProxyNode
		memento.putString(TestUIConstants.TAG_NAME, getText());
		//- data from EObjectProxyNode
		memento.putString(TestUIConstants.TAG_URI, getOriginatorURI().toString());
		return true;
	}
}
