/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DefaultTestComponentlProxyNode.java,v 1.4 2005/02/16 22:22:06 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.proxy;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.testprofile.TPFTestComponent;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.ITestComponentProxyNode;
import org.eclipse.hyades.test.ui.navigator.TypedElementProxyNode;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMemento;

/**
 * @author jgout
 * @since 3.2
 */
public class DefaultTestComponentlProxyNode extends TypedElementProxyNode implements ITestComponentProxyNode {
	/**
	 * @param tc
	 * @param parent
	 */
	public DefaultTestComponentlProxyNode(TPFTestComponent tc, Object parent) {
		super(tc, parent);
	}

	public DefaultTestComponentlProxyNode(IMemento memento, Object parent) {
		super(memento, parent);
	}
	
	public Image getImage() {
		return TestUIImages.INSTANCE.getImage(TestUIImages.IMG_TEST_COMPONENT);
	}
	
	public IProxyNode[] getChildren() {
		//- no children for this node
		return new IProxyNode[0];
	}
	
	public TPFTestComponent getTestComponent() {
		EObject tc = EMFUtil.getResourceSet().getEObject(getOriginatorURI(), true);
		if (tc instanceof TPFTestComponent) {
			return (TPFTestComponent) tc;
		} else {
			return null;
		}
	}
}
