/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DefaultTestSuiteProxyNode.java,v 1.4 2005/02/16 22:22:06 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.proxy;

import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.testprofile.TPFTestCase;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.ui.TestUIConstants;
import org.eclipse.hyades.test.ui.TestUIExtension;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.test.ui.navigator.CMNNamedElementProxyNode;
import org.eclipse.hyades.test.ui.navigator.HyadesProxyNodeFactory;
import org.eclipse.hyades.test.ui.navigator.IPersistableProxyNode;
import org.eclipse.hyades.test.ui.navigator.IPersistableTypedElementProxyFactory;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.ITestSuiteProxyNode;
import org.eclipse.hyades.test.ui.navigator.ITypedElementProxyFactory;
import org.eclipse.hyades.test.ui.navigator.TypedElementProxyNode;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.extension.IAssociationMapping;
import org.eclipse.hyades.ui.internal.extension.AssociationMappingRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMemento;

/**
 * @author jgout
 * @since 3.2
 */
public class DefaultTestSuiteProxyNode extends TypedElementProxyNode implements ITestSuiteProxyNode, IPersistableProxyNode {

	private IAssociationDescriptor descriptor;
	private CMNNamedElementProxyNode [] testCases;
	
	/**
	 * @param ts
	 * @param parent
	 */
	public DefaultTestSuiteProxyNode(TPFTestSuite ts, Object parent) {
		super(ts, parent);
		AssociationMappingRegistry registry = (AssociationMappingRegistry)TestUIExtension.getTestSuiteMappingRegistry();
		IAssociationMapping associationMapping = registry.getAssociationMapping(HyadesUIPlugin.EP_TYPE_DESCRIPTIONS);
		descriptor = associationMapping.getDefaultAssociationDescriptor(ts.getType());
		LinkedList tcProxies = new LinkedList();
		EList testcases = ts.getTestCases();
		for (Iterator iter = testcases.iterator(); iter.hasNext();) {
			TPFTestCase tc = (TPFTestCase) iter.next();
			IProxyNode proxy = HyadesProxyNodeFactory.getInstance().create(tc, this);
			if(proxy != null) {
				tcProxies.add(proxy);
			}
		}
		testCases = (CMNNamedElementProxyNode[]) tcProxies.toArray(new CMNNamedElementProxyNode[tcProxies.size()]);	
	}

	public DefaultTestSuiteProxyNode(IMemento memento ,Object parent) {
		super(memento, parent);
		//- set the descriptor according to the saved type. This is used in getImage() 
		AssociationMappingRegistry registry = (AssociationMappingRegistry)TestUIExtension.getTestSuiteMappingRegistry();
		IAssociationMapping associationMapping = registry.getAssociationMapping(HyadesUIPlugin.EP_TYPE_DESCRIPTIONS);
		descriptor = associationMapping.getDefaultAssociationDescriptor(getType());

		IMemento [] tcStates = memento.getChildren(TestUIConstants.TAG_CHILD);
		LinkedList tcProxies = new LinkedList();

		for (int i = 0; i < tcStates.length; i++) {
			IMemento mementoChild = tcStates[i];
			String type = mementoChild.getString(TestUIConstants.TAG_TYPE);
			if(type == null) {
				throw new IllegalArgumentException("Malformed saved proxy state: unable to retrieve type field"); //$NON-NLS-1$
			}
			ITypedElementProxyFactory factory = TypedElementFactoryManager.getInstance().getFactory(type);
			if(factory instanceof IPersistableTypedElementProxyFactory) {
				IProxyNode proxy = ((IPersistableTypedElementProxyFactory)factory).recreate(mementoChild, this);
				if(proxy != null) {
					tcProxies.add(proxy);
				}
			}
		}
		testCases = (CMNNamedElementProxyNode[]) tcProxies.toArray(new CMNNamedElementProxyNode[tcProxies.size()]);	
	}
	
	public Image getImage() {
		if(descriptor == null) {
			//- the type of this element wasn't registered by any extension (hyades.ui.typeDescriptions) 
			return TestUIImages.INSTANCE.getImage(TestUIImages.IMG_TEST_SUITE);
		} else {
			return descriptor.getImage();
		}
	}

	public IProxyNode[] getChildren() {
		return testCases;
	}
	
	public TPFTestSuite getTestSuite() {
		EObject ts = EMFUtil.getResourceSet().getEObject(getOriginatorURI(), true);
		if (ts instanceof TPFTestSuite) {
			return (TPFTestSuite) ts;
		} else {
			return null;
		}
	}
	
	public String getFactoryID() {
		return "EMFResourceProxyFactory"; //$NON-NLS-1$
	}
	
	public boolean saveState(IMemento memento) {
		//- data to retrieve the correct object 
		memento.putString(TestUIConstants.TAG_NODE_KIND, TestUIConstants.TESTSUITE_NODE);
		//- data from TypedElementProxyNode
		memento.putString(TestUIConstants.TAG_TYPE, getType());
		//- data from CMNNamedElementProxyNode
		memento.putString(TestUIConstants.TAG_NAME, getText());
		//- data from EObjectProxyNode
		memento.putString(TestUIConstants.TAG_URI, getOriginatorURI().toString());
		//- children (testcases)
		for (int i = 0; i < testCases.length; i++) {
			CMNNamedElementProxyNode tcProxy = testCases[i];
			if(tcProxy instanceof IPersistableProxyNode) {
				IMemento childMemento = memento.createChild(TestUIConstants.TAG_CHILD);
				if(!((IPersistableProxyNode)tcProxy).saveState(childMemento)) {
					return false;
				}
			} else {
				return false;
			}
		}
		return true;
	}	
}
