/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DeploymentProxyNode.java,v 1.4 2005/02/16 22:22:06 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.proxy;

import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.test.ui.TestUIConstants;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.navigator.CMNNamedElementProxyNode;
import org.eclipse.hyades.test.ui.navigator.IPersistableProxyNode;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMemento;

/**
 * @author jgout
 * @since 3.2
 */
public class DeploymentProxyNode extends CMNNamedElementProxyNode implements IPersistableProxyNode {
	/**
	 * @param deploy
	 * @param parent
	 */
	public DeploymentProxyNode(TPFDeployment deploy, Object parent) {
		super(deploy, parent);
	}

	/**
	 * @param memento
	 * @param parent
	 */
	public DeploymentProxyNode(IMemento memento, Object parent) {
		super(memento, parent);
	}

	public Image getImage() {
		return TestUIImages.INSTANCE.getImage(TestUIImages.IMG_DEPLOYMENT);
	}
	
	public IProxyNode[] getChildren() {
		//- no children for this node
		return new IProxyNode[0];
	}
	
	public String getFactoryID() {
		return "EMFResourceProxyFactory"; //$NON-NLS-1$
	}
	
	public boolean saveState(IMemento memento) {
		//- data to retrieve the correct object 
		memento.putString(TestUIConstants.TAG_NODE_KIND, TestUIConstants.DEPLOY_NODE);
		//- data from CMNNamedElementProxyNode
		memento.putString(TestUIConstants.TAG_NAME, getText());
		//- data from EObjectProxyNode
		memento.putString(TestUIConstants.TAG_URI, getOriginatorURI().toString());
		return true;
	}
}
