/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestUIUtil.java,v 1.6 2005/02/16 22:22:11 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.util;

import java.util.Iterator;
import java.util.List;

import org.eclipse.hyades.models.common.common.CMNNamedElement;
import org.eclipse.hyades.test.ui.TestUIPlugin;

/**
 * @author marcelop
 * @since 0.3.0
 * @deprecated use {@link org.eclipse.hyades.test.ui.util.TestUIUtil} instead.
 */
public class TestUIUtil
{
	/**
	 * Returns a unique name based on the specified base and list of CMNNamedElement.
	 * @param baseName
	 * @param namedElementList
	 * @return String
	 */
	public static String getUniqueName(String baseName, List namedElementList)
	{
		int id = namedElementList.size()+1;
		String[] args = new String[]{baseName, Integer.toString(id)};
		String name = TestUIPlugin.getString("NME_CONCAT", args); //$NON-NLS-1$

		for (Iterator i = namedElementList.iterator(); i.hasNext();)
		{
			CMNNamedElement namedElement = (CMNNamedElement)i.next();
			if(name.equals(namedElement.getName()))
			{
				args[1] = Integer.toString(++id);
				name = TestUIPlugin.getString("NME_CONCAT", args); //$NON-NLS-1$
				i = namedElementList.iterator();
			}
		}
		
		return name;
	}
}
