/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: BasicTestComponentLaunchConfigurationDelegate2.java,v 1.3 2005/02/16 22:22:13 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.launch.delegates;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.models.common.testprofile.TPFTestComponent;
import org.eclipse.hyades.test.ui.launch.configurations.DeploymentLaunchConfigurationFacade;
import org.eclipse.hyades.test.ui.launch.configurations.ExecutionHistoryLaunchConfigurationFacade;
import org.eclipse.hyades.test.ui.launch.configurations.TestComponentLaunchConfigurationFacade;

/**
 * This class is the Delegate for the basic Hyades Launch Configuration.
 * It handles the launching of a Hyades Test Component according to a Hyades Launch Configuration.
 * In Atlantic, this Launch Configuration delegate is abstract: the invokeTestExecutionHarness()
 * method must be implemented in sub-classes. In future versions, a Basic Test Component
 * Launch Configuration will be available and this class will be instantiable.
 * @see ILaunchConfigurationDelegate
 * @author jcanches
 */
public abstract class BasicTestComponentLaunchConfigurationDelegate2 extends AbstractLaunchConfigurationDelegate2 {
	
    /**
     * Create a Hyades Basic Launch Configuration Delegate.
     */
    public BasicTestComponentLaunchConfigurationDelegate2() {
    }

    protected TPFTestComponent getLaunchedTestComponent(ILaunchConfiguration configuration) throws CoreException {
    	return TestComponentLaunchConfigurationFacade.getTestComponent(configuration, getResourceSet());
    }
    
    protected TPFDeployment getDeployment(ILaunchConfiguration configuration) throws CoreException {
    	return DeploymentLaunchConfigurationFacade.getDeployment(configuration, getResourceSet());
    }
    
    protected String getTestExecutionHistoryName(ILaunchConfiguration configuration) throws CoreException {
    	return ExecutionHistoryLaunchConfigurationFacade.getExecutionHistoryName(configuration);
    }
    
    protected IContainer getTestExecutionHistoryLocation(ILaunchConfiguration configuration) throws CoreException {
    	return ExecutionHistoryLaunchConfigurationFacade.getExecutionHistoryLocation(configuration);
    }   
    
	protected Object getLaunchedElement(ILaunchConfiguration configuration)	throws CoreException {
		return getLaunchedTestComponent(configuration);
	}
	
    protected void validate(ILaunchConfiguration configuration, String mode) throws CoreException {
    	super.validate(configuration, mode);
   	
    	if (getDeployment(configuration) == null) {
			reportProblem("The configuration does not provide a Deployment"); //$NON-NLS-1$
		}
    	
    	String tehName = getTestExecutionHistoryName(configuration);
    	if (tehName == null || tehName.equals("")) { //$NON-NLS-1$
    		reportProblem("The configuration does not provide a Test Execution History Name"); //$NON-NLS-1$
    	}
    	
    	IContainer tehLocation = getTestExecutionHistoryLocation(configuration);
    	if (tehLocation == null) {
    		reportProblem("The configuration does not provide a Test Execution History Location"); //$NON-NLS-1$
    	} else if (!tehLocation.exists()) {
    		reportProblem("The Test Execution History Location described by the configuration does not exist"); //$NON-NLS-1$
    	}
    }
        
}
