/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: CMNNamedElementProxyNode.java,v 1.7 2005/03/21 17:47:35 dguilbaud Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.navigator;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.common.common.CMNNamedElement;
import org.eclipse.hyades.test.ui.TestUIConstants;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.test.ui.internal.navigator.action.RenamerUIStatus;
import org.eclipse.hyades.test.ui.navigator.actions.IProxyNodeRenamer;
import org.eclipse.hyades.test.ui.navigator.actions.RenamerUIInlineEditor;
import org.eclipse.ui.IMemento;

/**
 * @author jgout
 */
public abstract class CMNNamedElementProxyNode extends EObjectProxyNode implements IProxyNodeRenamer {
	private String name;

	public CMNNamedElementProxyNode(IMemento memento, Object parent) {
		super(memento, parent);
		this.name = memento.getString(TestUIConstants.TAG_NAME);
		if(this.name == null) {
			throw new IllegalArgumentException("Malformed saved proxy state: unable to retrieve name field"); //$NON-NLS-1$
		}
	}
	
	/** Constructor
	 * 
	 * @param eObject the EMF named object to convert, the first argument should be a descendant of CMNNamedElement.
	 * @param parent its parent node.
	 */
	public CMNNamedElementProxyNode(EObject eObject, Object parent) {
		super(eObject, parent);
		if(eObject instanceof CMNNamedElement) {
			this.name = ((CMNNamedElement)eObject).getName();
		} else {
			throw new IllegalArgumentException("CMNNamedElementProxyNode can only be built upon CMNNamedElement"); //$NON-NLS-1$
		}
	}

	/** Returns the name of the named element given in the constructor. 
	 *  This name is used as the text shown in the navigator.
	 *  @return the name of the proxy.
	 */
	public String getText() {
		return this.name;
	}
	
	protected void setName(String name) {
		this.name = name;
	}
	
	public Object getAdapter(Class adapter) {
		//- this proxy is adaptable in IResource if it has been placed instead of a file
		if(adapter.equals(IResource.class) && getParent() instanceof IContainer) {
			return getUnderlyingResource();
		} else if (adapter == IProxyNodeRenamer.class) {
			return this;
		} else {
			return Platform.getAdapterManager().getAdapter(this, adapter);
		}
	}

	public boolean isApplicableFor() {
		return true;
	}
	
	public boolean performRename(String newName) {
		CMNNamedElement eObject = (CMNNamedElement)getEObject(); 
		Resource res = eObject.eResource();
		if(res == null) {
			res = EMFUtil.getResource(null, eObject);
		}
		if(!eObject.getName().equals(newName)) {
			eObject.setName(newName);
			if(res != null) {
				try {
					EMFUtil.save(res);
				} catch (Exception e) {
					TestUIPlugin.logError(e);
				}
			}
		}
		//- clear memory
		if(res != null) {
			res.unload();
		}
		return false;
	}
	
	public RenamerUIStatus performUserInteraction(String oldName) {
		return new RenamerUIInlineEditor();
	}
}
