/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ProxyNodeTransfer.java,v 1.3 2005/02/16 22:22:14 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.ui.navigator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.FileProxyManager;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;

/** Transfer class used by Copy/Paste actions
 * @author jgout
 * @since 3.3
 */
public class ProxyNodeTransfer extends ByteArrayTransfer {
	private static final ProxyNodeTransfer instance = new ProxyNodeTransfer();
	//- Create a unique ID to make sure that different Eclipse
	//- applications use different "types" of <code>ProxyNodeTransfer</code>
	private static final String TYPE_NAME = "proxy-transfer-format" + System.currentTimeMillis() + ":" + instance.hashCode();//$NON-NLS-2$//$NON-NLS-1$
	private static final int TYPEID = registerType(TYPE_NAME);

	/** Returns the singleton instance.
	 * 
	 * @return the singleton instance
	 */
	public static ProxyNodeTransfer getInstance() {
		return instance;
	}

	protected int[] getTypeIds() {
		return new int[]{TYPEID};
	}

	protected String[] getTypeNames() {
		return new String[]{TYPE_NAME};
	}

	private void writeProxy(DataOutputStream dataOut, IProxyNode proxy) throws IOException {
		//- the full name of the underlying resource
		dataOut.writeUTF(proxy.getUnderlyingResource().getLocation().toOSString());
		//- identifier
		dataOut.writeUTF(proxy.getIdentifier());
	}

	private IProxyNode readProxy(DataInputStream dataIn) throws IOException {
		String fileName = dataIn.readUTF();
		String identifier = dataIn.readUTF();
		return FileProxyManager.getInstance().getCorrespondingProxy(fileName, identifier);
	}

	protected void javaToNative(Object object, TransferData transferData) {
		Object[] proxies = (Object[]) object;
		ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
		DataOutputStream out = new DataOutputStream(byteOut);
		byte[] bytes = null;
		try {
			//- write number of proxies 
			out.writeInt(proxies.length);
			for (int i = 0; i < proxies.length; i++) {
				writeProxy(out, (IProxyNode) proxies[i]);
			}
			out.close();
			bytes = byteOut.toByteArray();
		} catch (IOException e) {
			//- when in doubt send nothing
		}
		if (bytes != null) {
			super.javaToNative(bytes, transferData);
		}
	}

	protected Object nativeToJava(TransferData transferData) {
		byte[] bytes = (byte[]) super.nativeToJava(transferData);
		DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes));
		try {
			//- read number of proxies
			int n = in.readInt();
			//- read proxies
			IProxyNode[] proxies = new IProxyNode[n];
			for (int i = 0; i < n; i++) {
				IProxyNode proxy = readProxy(in);
				if (proxy == null) {
					return null;
				}
				proxies[i] = proxy;
			}
			return proxies;
		} catch (IOException e) {
			return null;
		}
	}
}