/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestUIUtil.java,v 1.6 2005/03/02 23:41:34 bjiang Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.util;

import java.io.File;
import java.util.Iterator;
import java.util.List;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.common.common.CMNNamedElement;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;

/**
 * @author marcelop
 * @since 0.3.0
 */
public class TestUIUtil
{
	/**
	 * Returns a unique name based on the specified base and list of CMNNamedElement.
	 * @param baseName
	 * @param namedElementList
	 * @return String
	 */
	public static String getUniqueName(String baseName, List namedElementList)
	{
		int id = namedElementList.size()+1;
		String[] args = new String[]{baseName, Integer.toString(id)};
		String name = TestUIPlugin.getString("NME_CONCAT", args);

		for (Iterator i = namedElementList.iterator(); i.hasNext();)
		{
			CMNNamedElement namedElement = (CMNNamedElement)i.next();
			if(name.equals(namedElement.getName()))
			{
				args[1] = Integer.toString(++id);
				name = TestUIPlugin.getString("NME_CONCAT", args);
				i = namedElementList.iterator();
			}
		}
		
		return name;
	}
	
	/**
	 * This method validates that an extension was added to the file name. If the file 
	 * fails either test for a valid extension, the correct extension is appended to 
	 * the file name.
	 * @param result The result returned from the dialog's file name control
	 * @param extension The extension to add to the file name 
	 * @return correct file name with extension
	 */
	public static String validateExtension(String result, String extension) {
		/*
		 * 1. Test if the string is missing a "."
		 * 2. Test if the string contains the correct extension
		 */
		if (result.lastIndexOf(".") == -1 || 
				!result.substring(result.lastIndexOf(".")+1, result.length()).equalsIgnoreCase(extension)) {
			return result + "." + extension;
		}

		return result;
	}
	
	/**
	 * Opens the editor for the specified EMF resource.
	 * 
	 * <p>If <code>editorId</code> is null the default editor is opened.  
	 * If substring is true then the <code>editorId</code> value is considered to be 
	 * first part of the editor id.
	 * 
	 * @param resource;
	 * @param editorId;
	 * @param substring;
	 * @return The opened editor part or <code>null</code> if this method was not
	 * able to open the editor.
	 */
	public static IEditorPart openEditor(Resource resource, String editorId, boolean substring)
	{
		IFile file = EMFUtil.getWorkspaceFile(resource);
		if (file != null && file.exists())
		{
			return UIUtil.openEditor(file, editorId, substring);
		}
		IWorkbench workbench = PlatformUI.getWorkbench();
		IWorkbenchPage activePage = null;
		if(workbench.getActiveWorkbenchWindow() != null)
		{
			activePage = workbench.getActiveWorkbenchWindow().getActivePage();
		}
		else if(workbench.getWorkbenchWindows().length > 0)
		{
			activePage = workbench.getWorkbenchWindows()[0].getActivePage();
		}
		
		String location = EMFUtil.getFilePath(resource);
		File ioFile = new File(location);
		RCPFileEditorInput input = new RCPFileEditorInput(ioFile);
		if (editorId == null)
		{
			IEditorRegistry editorRegistry= workbench.getEditorRegistry();
			IEditorDescriptor descriptor= editorRegistry.getDefaultEditor(ioFile.getName());
			if (descriptor != null)
				editorId = descriptor.getId();
			else
				editorId = EditorsUI.DEFAULT_TEXT_EDITOR_ID;
		}
		try {
			return activePage.openEditor(input, editorId, substring);
		} catch (PartInitException e) {
			HyadesUIPlugin.logError(e);
		}
		return null;
		
	}
	
}
