package org.eclipse.hyades.logging.adapter;

import org.eclipse.hyades.logging.adapter.util.Messages;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AdapterException.java,v 1.6 2005/03/23 08:09:06 dnsmith Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
public class AdapterException extends Exception
{
    /**
     * Variable to hold wrapped existing exception.
     */
    private Throwable exception;

	/**
	 * Constructor for LogParserException.
	 */
	public AdapterException()
	{
		super();
		this.exception = null;
	}
	/**
	 * Constructor for AdapterException.
	 * @param message
	 */
	public AdapterException(String message)
	{
		super(message);
		this.exception = null;
	}
	/**
	 * Constructor for AdapterException.
	 * @param message
	 * @param cause
	 */
	public AdapterException(String message, Throwable cause)
	{
		super(message);
		this.exception = cause;
	}
	/**
	 * Constructor for AdapterException.
	 * @param cause
	 */
	public AdapterException(Throwable cause)
	{
		super();
		this.exception = cause;
	}
	
    /**
     * Return a detail message for this exception.
     *
     * <p>If there is an embedded exception, and if the AdapterException
     * has no detail message of its own, this method will return
     * the detail message from the embedded exception.</p>
     * <p>If there is an embedded exception, and the AdapterException
     * has a detail message of its own, this method will append the
     * embedded exception message to the AdapterException message and
     * return it.</p>
     *
     * @return The error or warning message.
     */
    public String getMessage() {
        String message = super.getMessage();
        Throwable cause = this.getException();
        String excMessage = null;

        // If there is an embedded exception Then get its message
    	if (cause != null) {
    		excMessage = cause.getMessage();
    		if (excMessage == null || excMessage.length() == 0) {
    			excMessage = cause.toString();
    		}
    	}
    	// If three is no detail message then return the embedded exception 
    	// message if one exists.
        if (message == null || message.length() == 0) {
        	if (excMessage != null) {
        		return excMessage;
        	}
        	else {
        		return null;
        	}
        }
        // If there is a detail message and an embedded exception message then
        // concatenate them.
        else if (excMessage != null){
            return message + "  " + Messages.getString("EXCEPTION") + " = " + excMessage;
        }
        // If there is only a detail message then return that
        else {
            return message;
        }
    }

    /**
     * Return the embedded exception, if any.
     *
     * @return The embedded exception, or null if there is none.
     */
    public Throwable getException() {
        return exception;
    }
}
