/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IComponentBroker.java,v 1.3 2005/02/16 22:20:29 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.logging.adapter;

/**
 * Event broker is used to accept incomming data from registered producers
 * and reroute to registered consumers. This is running under a multi-threaded
 * environment. Event broker implementations should create a queue to receive
 * data coming from event producers.
 */
public interface IComponentBroker {
	public void addEventConsumer(IComponent con);
	public void queueEvents(Object[] obj);
	public void setNextBroker(IComponentBroker next);
	public void start();
	public void flushAndTerminate() throws InterruptedException;
}
