/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IDirectedGraph.java,v 1.3 2005/02/16 22:20:29 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.logging.adapter;

import java.util.List;

/**
 * @author rduggan
 *
 * This is a simple interface to capture path information as well as
 * a value.  The idea is that consumers can use the path to locate an
 * object and then either retrieve or manipulate that object using the
 * provided value.
 * 
 * For example, say we map the members of classes to nodes in a graph.
 * Each member can be a simple type or an object of another class with 
 * members of its own.  Each member of a class can be represented by 
 * a unique name or number amongst all members of all classes.  To find 
 * a member B of one class that is in an object which is member A of 
 * an object of another class we can use a list of 
 * names or numbers (eg. A,B) as the path to get to B and manipulate
 * B's value.  Now say B is of the same complex type as the class it is 
 * a member of so we can have a linked list of objects of the same type.
 * We can represent a member C of the second B member in the linked list
 * with the path or list A,B,B,C.
 * 
 */
public interface IDirectedGraph {
	
	/**
	 * Retrieve the stored path
	 * @return
	 */
	public List getPath();

	/**
	 * Set the path
	 * @param path
	 */	
	public void setPath(List path);
	
	/**
	 * retrieve the value
	 * @return
	 */
	public Object getValue();
	
	/**
	 * Set the value
	 * @param value
	 */
	public void setValue(Object value);

}
