/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ComponentFactory.java,v 1.6 2005/02/16 22:20:29 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.logging.adapter.impl;
import org.eclipse.hyades.logging.adapter.internal.util.ComponentLoaderUtil;
import org.eclipse.hyades.logging.adapter.parsers.PreparationException;
import org.eclipse.hyades.logging.adapter.util.Messages;
/**
 * <p>Title: ComponentFactory.java</p>
 * <p>Description: Create Component objects
 * </p>
 * @author HS
 * @version 0.1
 * @see 
 **/
public class ComponentFactory
{
	private ComponentFactory()
	{
	}
	public static Component buildComponent(String classname, String id, String name) throws PreparationException {
		Component component = null;
		if (classname != null) {
			try {
			component =(Component)ComponentLoaderUtil.instantiate(classname, "org.eclipse.hyades.logging.adapter.impl.Component");
			}
			catch(PreparationException e) {
				/* Something went wrong building the component.  We need to add some infor to the exception and throw it on up the stack */
            	PreparationException eprime=new PreparationException(Messages.getString("HyadesGAComponentInstantiation_ERROR_", name, e.getMessage()));
            	throw eprime;
			}
			component.setName(name);
			component.setExecutableClassName(classname);
			component.setUniqueID(id);
		}
		return component;
	}
}
