/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IFilterBlock.java,v 1.1 2005/03/23 23:37:14 dnsmith Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.logging.adapter.internal.filters;

import java.util.List;

/**
 * @author rduggan
 *
 * This interface represences a generic block of filters
 */
public interface IFilterBlock extends IFilterElement {	
	
	/**
	 * Retrieve this filter block's collection of filter elements.
	 * @return
	 */
	public List getFilterElements();
	
	/**
	 * Add a filter element to this blocks collection of filter elements
	 * @param element
	 */
	public void addFilterElement(IFilterElement element);
}
