/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: NumericalFilterType.java,v 1.2 2005/03/24 19:23:57 dnsmith Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.logging.adapter.internal.filters;

/**
 * @author rduggan
 *
 * This class represents a numerical filter type.
 */
public class NumericalFilterType implements IFilterType {

	public static final String EQUALS 		= "equals";
	public static final String GREATERTHAN 	= "greaterThan";
	public static final String LESSTHAN		= "lessThan";
	public static final String GREATERTHANOREQUAL 	= "greaterThanOrEqual";
	public static final String LESSTHANOREQUAL		= "lessThanOrEqual";
	
	private static final String[] operands = {GREATERTHAN, LESSTHAN, EQUALS, GREATERTHANOREQUAL, LESSTHANOREQUAL};
	
	/**
	 * @see org.eclipse.hyades.logging.adapter.filters.IFilterType#getOperators()
	 */
	public String[] getOperators() {
		return operands;
	}

	/**
	 * @see org.eclipse.hyades.logging.adapter.filters.IFilterType#processRule(java.lang.String, java.lang.String)
	 */
	public boolean processRule(IFilterAtom rule) {
		boolean result=rule.isNegated();
		if (rule.getOperator().equals(GREATERTHANOREQUAL)) {
			result=greaterThan(rule.getLeftOperand(), rule.getRightOperand()) || equals(rule.getLeftOperand(), rule.getRightOperand());;
		}
		else if (rule.getOperator().equals(LESSTHANOREQUAL)) {
			result=lessThan(rule.getLeftOperand(), rule.getRightOperand()) || equals(rule.getLeftOperand(), rule.getRightOperand());;
		}
		else if (rule.getOperator().equals(EQUALS)) {
			result=equals(rule.getLeftOperand(), rule.getRightOperand());
		}
		if (rule.getOperator().equals(GREATERTHAN)) {
			result=greaterThan(rule.getLeftOperand(), rule.getRightOperand());
		}
		else if (rule.getOperator().equals(LESSTHAN)) {
			result=lessThan(rule.getLeftOperand(), rule.getRightOperand());
		}
		if(rule.isNegated()) {
			return !result;
		}
		return result;
	}
	
	/* 
	 * equals operator 
	 */
	protected boolean equals(String lhs, String rhs) {
		// check for null operands
		if (lhs == null && rhs == null ) {
			return true;
		}
		else if (lhs == null || rhs == null) { 
			return false;
		}
	
		try {
			int lnum = Integer.parseInt(lhs);
			int rnum = Integer.parseInt(rhs);
			return lnum == rnum;
		}
		catch (NumberFormatException e) {
			
		}
		
		try {
			float lnum = Float.parseFloat(lhs);
			float rnum = Float.parseFloat(rhs);
			return lnum == rnum;
		}
		catch (NumberFormatException e) {
			
		}
		
		try {
			double lnum = Double.parseDouble(lhs);
			double rnum = Double.parseDouble(rhs);
			return lnum == rnum;
		}
		catch (NumberFormatException e) {
			
		}
		return false;	
	}

	/*
	 * greater than operator
	 */
	protected boolean greaterThan(String lhs, String rhs) {
		// check for null operands
		if (lhs == null || rhs == null) { 
			return false;
		}
		try {
			int lnum = Integer.parseInt(lhs);
			int rnum = Integer.parseInt(rhs);
			return lnum > rnum;
		}
		catch (NumberFormatException e) {
			
		}
		
		try {
			float lnum = Float.parseFloat(lhs);
			float rnum = Float.parseFloat(rhs);
			return lnum > rnum;
		}
		catch (NumberFormatException e) {
			
		}
		
		try {
			double lnum = Double.parseDouble(lhs);
			double rnum = Double.parseDouble(rhs);
			return lnum > rnum;
		}
		catch (NumberFormatException e) {
			
		}
		
		return false;	
	}
	
	/* 
	 * less than operator
	 */
	protected boolean lessThan(String lhs, String rhs) {
		// check for null operands
		if (lhs == null || rhs == null) { 
			return false;
		}
		
		try {
			int lnum = Integer.parseInt(lhs);
			int rnum = Integer.parseInt(rhs);
			return lnum < rnum;
		}
		catch (NumberFormatException e) {
			
		}
		
		try {
			float lnum = Float.parseFloat(lhs);
			float rnum = Float.parseFloat(rhs);
			return lnum < rnum;
		}
		catch (NumberFormatException e) {
			
		}
		
		try {
			double lnum = Double.parseDouble(lhs);
			double rnum = Double.parseDouble(rhs);
			return lnum < rnum;
		}
		catch (NumberFormatException e) {
			
		}
		return false;	
	}

}
