/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: NumericalRangeFilterType.java,v 1.1 2005/03/28 08:38:46 dnsmith Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.logging.adapter.internal.filters;

/**
 * @author rduggan
 *
 * This class represents a numerical filter type.
 */
public class NumericalRangeFilterType implements IFilterType {

	public static final String LAST 		= "last";
	public static final String FIRST	 	= "first";
	
	private static final String[] operands = {FIRST, LAST};
	
	/**
	 * @see org.eclipse.hyades.logging.adapter.filters.IFilterType#getOperators()
	 */
	public String[] getOperators() {
		return operands;
	}

	/**
	 * @see org.eclipse.hyades.logging.adapter.filters.IFilterType#processRule(java.lang.String, java.lang.String)
	 */
	public boolean processRule(IFilterAtom rule) {
		boolean result=rule.isNegated();
		if (rule.getOperator().equals(FIRST)) {
			result=first(rule.getLeftOperand(), rule.getRightOperand());
		}
		else if (rule.getOperator().equals(LAST)) {
			result=last(rule.getLeftOperand(), rule.getRightOperand());
		}

		if(rule.isNegated()) {
			return !result;
		}
		return result;
	}
	
	/* 
	 * last operator 
	 */
	protected boolean last(String lhs, String rhs) {
		// Always return true because the last processing will be done
		// when the event is cached in the helper class
		return true;	
	}

	
	/* 
	 * first operator
	 * Checks whether the first operand is less than or equal to the
	 * second operand.
	 */
	protected boolean first(String lhs, String rhs) {
		// check for null operands
		if (lhs == null || rhs == null) { 
			return false;
		}
		
		try {
			int lnum = Integer.parseInt(lhs);
			int rnum = Integer.parseInt(rhs);
			return lnum <= rnum;
		}
		catch (NumberFormatException e) {
			
		}
		
		try {
			float lnum = Float.parseFloat(lhs);
			float rnum = Float.parseFloat(rhs);
			return lnum <= rnum;
		}
		catch (NumberFormatException e) {
			
		}
		
		try {
			double lnum = Double.parseDouble(lhs);
			double rnum = Double.parseDouble(rhs);
			return lnum <= rnum;
		}
		catch (NumberFormatException e) {
			
		}
		return false;	
	}

}
