package org.eclipse.hyades.logging.adapter.internal.util;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: GlaTaskOutputter.java,v 1.5 2005/02/16 22:20:29 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

import java.util.Hashtable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
//import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;
import org.eclipse.hyades.logging.adapter.IOutputter;
import org.eclipse.hyades.logging.adapter.impl.Outputter;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
//import org.eclipse.hyades.logging.events.cbe.ExtendedDataElement;

/**
 * CBEEclipseErrorDialogOutputter is an outputter that takes the given CBEs and
 * outputs them to an Eclipse error dialog.
 * 
 * @author Paul E. Slauenwhite
 */
public class GlaTaskOutputter extends Outputter implements IOutputter {

	/* The resource that this adapter file corresponds to in the workbench */
	IFile resource;
	
    public Object[] processEventItems(Object[] msgs) {

        if (msgs == null) {
            return msgs;
        }

        return processCBEs((CommonBaseEvent[]) msgs);
    }
    
    public void update() throws AdapterInvalidConfig {
		// first get the basic configuration set
		super.update();
		
		/* Get our resource name */
		Hashtable outputterProperties = getProperties();		
		if (outputterProperties != null && !outputterProperties.isEmpty()) {
			String resourcePath = (String)outputterProperties.get("resourceName");
			if(resourcePath!=null && !resourcePath.equals("")) {
				/* Resolve our resource.  This will not be resolvable if the file is not in the workspace. */
				IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
				resource = workspaceRoot.getFileForLocation(new Path(resourcePath));
			}
		}
	}

    private CommonBaseEvent[] processCBEs(CommonBaseEvent[] events) {

        short currentLoggingLevel = getLoggingLevel();
        
        /* The resource may be null as the file we are processing may not be in the workspace. */
        if(resource!=null) {
        	

	        for (int i = 0; i < events.length; i++) {
	
	            final CommonBaseEvent event = ((CommonBaseEvent)(events[i]));
	            short severity = event.getSeverity();
	
	            /* if we are logging greater then our set logging level */
	            if ((events[i] != null) && ((severity >= currentLoggingLevel))) {
					IMarker marker=createProblemMarker(resource);
					if (marker.exists()) {
						try {
							marker.setAttribute(IMarker.MESSAGE, events[i].getMsg());
							
							/* RKD:  This was supposed to help with the F1 help.  Could not
							 * get this working correctly.  See comments in plugin.xml.
							 
							marker.setAttribute("help", "1234");
							*/
							
							
							
							/* RKD:  Map the severity or problems to the IMarker severities.
							 * The priorities are there for the tasks list if that is desired
							 * at some point.
							 */
							if(events[i].getSeverity()>=50) {
								//marker.setAttribute(IMarker.PRIORITY, IMarker.PRIORITY_HIGH);
								marker.setAttribute(IMarker.SEVERITY, IMarker.SEVERITY_ERROR);
							}
							else if(events[i].getSeverity()>=20) {
								//marker.setAttribute(IMarker.PRIORITY, IMarker.PRIORITY_NORMAL);
								marker.setAttribute(IMarker.SEVERITY, IMarker.SEVERITY_WARNING);
							}
							else if(events[i].getSeverity()>0) {
								//marker.setAttribute(IMarker.PRIORITY, IMarker.PRIORITY_LOW);
								marker.setAttribute(IMarker.SEVERITY, IMarker.SEVERITY_INFO);
							}
							
							/* allow the user to edit the issue */
							marker.setAttribute(IMarker.USER_EDITABLE, true);
							
							/* RKD:  Experementing with attributes for the builder 
							EList edeList=events[i].getExtendedDataElements("PATH");
							if(!edeList.isEmpty()) {
								ExtendedDataElement element=(ExtendedDataElement)edeList.get(0);
								marker.setAttribute("graph", element.getValuesAsString());				         	
							}
							*/
							
						} catch (CoreException e) {
					         // need to handle the case where the marker no longer exists
						}
					}
	            }
	        }
        }

        return events;
    }

    public Object[] testEventInterface(Object[] msgs) throws AdapterInvalidConfig {
        return testProcessCBEs((CommonBaseEvent[]) msgs);
    }

    private CommonBaseEvent[] testProcessCBEs(CommonBaseEvent[] events) {
        return events;
    }
    
    
    /**
     * Factory method for Markers
     * @param resource - the resource that the marker will be associated with
     * @return
     */
    private IMarker createProblemMarker(IResource resource) {
        try {
        	/* You can create a marker using the workbench supplied types or your own.  We will use our own. */
            IMarker marker = resource.createMarker("org.eclipse.hyades.logging.adapter.glaproblemmarker");
            return marker;
         } catch (CoreException e) {
            return null;
         }
      }
}
