package org.eclipse.hyades.logging.adapter.internal.util;


import org.eclipse.hyades.logging.adapter.AdapterPlugin;
import org.eclipse.hyades.logging.adapter.parsers.ISubstitutionExtension;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SubstitutionExtensionLoaderUtil.java,v 1.4 2005/02/16 22:20:29 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
public class SubstitutionExtensionLoaderUtil
{
	/**
	 * Instatiate an object and guarantee its class.
	 * @param extClass The extension class class
	 * @param className The name of the class to instantiate.
	 **/
	public static ISubstitutionExtension instantiate(Class extClass, String className) throws ClassNotFoundException, ClassCastException
	{	
		ISubstitutionExtension extension = null;
		
		try
		{
			Class o;
			// If the class class was not passed in then get it
			if (extClass == null) {
				o = Class.forName(className);
			}
			else {
				o = extClass;
			}

			extension = (ISubstitutionExtension)o.newInstance();

		}
		catch (ClassCastException e) {
			/* If we don't have an implementation of ISubstitutionExtension then
			 * throw a ClassNotFoundException.
			 */
			throw e;
		}
		catch (Throwable e) {
			/* We may be running inside of eclipse.  If this is the case then we will 
			 * look at our extensions to see if anyone has provided this class in 
			 * another plugin.
			 */
			 
			 try {
			 	extension = AdapterPlugin.getSubstitutionExtension(className);
			 }
			 catch(ClassCastException exc) {
			 	throw exc;
			 }
			 catch(Throwable eprime) {
			 	throw new ClassNotFoundException(eprime.toString()) ;
			 }
		}
		// Don't return a null extension object
		if (extension == null) {
			throw new ClassNotFoundException(className) ;
		}
		return extension;
	}
	
	/**
	 * Instatiate an object and guarantee its class.
	 * @param className The name of the class to instantiate.
	 **/
	public static ISubstitutionExtension instantiate(String className) throws ClassNotFoundException, ClassCastException
	{	
		ISubstitutionExtension extension = null;
			 
		try {
			/* We may be running inside of eclipse.  If this is the case then we will 
			 * look at our extensions to see if anyone has provided this class in 
			 * another plugin.
			 */
			extension = AdapterPlugin.getSubstitutionExtension(className);
		}
		catch(ClassCastException e) {
			throw e;
		}
		catch(Throwable eprime) {
			throw new ClassNotFoundException(eprime.toString()) ;
		}
		
		// Don't return a null extension object
		if (extension == null) {
			throw new ClassNotFoundException(className) ;
		}
		return extension;
	}
}