/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: PreparationException.java,v 1.8 2005/02/16 22:20:30 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.logging.adapter.parsers;

import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;

/**
 * @author rduggan
 *
 * A parser preparation exception.
 * 
 */ 
public class PreparationException extends AdapterInvalidConfig {

	private String details = null;
	private String digraph;
	
	
	/**
	 * 
	 */
	public PreparationException() {
		super();
	}

	/**
	 * @param message
	 */
	public PreparationException(String message) {
		super(message);
	}

	/**
	 * @param message
	 * @param cause
	 */
	public PreparationException(String message, Throwable cause) {
		super(message, cause);
	}

	/**
	 * @param cause
	 */
	public PreparationException(Throwable cause) {
		super(cause);
	}
	
	public String getDetails() {
		return details;
	}
	
	public void setDetails(String details) {
		this.details=details;
	}
	
	public String getDigraph() {
		return digraph;
	}
	
	public void setDigraph(String graph) {
		this.digraph=graph;
	}
	
}
