/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IComponentMigrator.java,v 1.4 2005/02/16 22:20:30 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.logging.adapter.util;

import org.w3c.dom.Element;

/**
 * This interface defines a migrator class to migrate a component configuration
 * from one version to another.
 */
public interface IComponentMigrator {
	
	/**
	 * Migrate method
	 * 
	 * @param oldConfiguration
	 * @return new configuration
	 * @throws AdapterMigrationException
	 */
	
	public Element migrate(Element oldConfiguration) throws AdapterMigrationException;

}
