/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.statistical.ui.editor.internal;

import java.text.DecimalFormat;

import org.eclipse.hyades.statistical.ui.EditorPlugin;
import org.eclipse.hyades.statistical.ui.widgets.alert.internal.Alert;
import org.eclipse.hyades.statistical.ui.widgets.alert.internal.AlertRegistry;
import org.eclipse.hyades.statistical.ui.widgets.internal.GData;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class AlertTableDialog extends Dialog implements SelectionListener {

	DecimalFormat df = new DecimalFormat("###########################################.########################################");
	
	Alert monitor;
	
	Shell shell;
	
	Composite main_panel;
	
//	Label error_img;
//	Label error_label;
	
	boolean modified = false;
	
	AlertTableMultiPanel trigger_panel;
	AlertTableMultiPanel reset_panel;

	Composite button_panel;
		Button button_ok;
		Button button_cancel;
		
	public AlertTableDialog(Shell shell, Alert monitor) {
		super(shell);
		this.monitor = monitor;
	}

	
	public boolean open() {
		
		int WIDTH = 300;
		int HEIGHT = 300;
		
		Shell parent = getParent();
		shell = new Shell(parent, SWT.RESIZE | SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL);
		shell.setText(EditorPlugin.getString("CONFIGURE_ALERT"));
		shell.setLayout(new FillLayout());
		shell.setBounds(0,0,WIDTH,HEIGHT);
		
		initGraphics();
		initEventHandling();

		shell.pack();

		Rectangle r = parent.getBounds();
		Rectangle z = shell.getBounds();
		if (z.width < WIDTH) z.width = WIDTH;
		if (z.height < HEIGHT) z.height = HEIGHT;

		shell.setBounds( r.x + (r.width/2) - (z.width/2),
						 r.y + (r.height/2) - (z.height/2),
						 z.width,
						 z.height
						 );
		
		shell.open();
		Display display = parent.getDisplay();
		while (!shell.isDisposed()) {
			if (!display.readAndDispatch()) display.sleep();
		}
		
		return modified;
	}

	public void widgetDefaultSelected(SelectionEvent e) {
		widgetSelected(e);
	}
	public void widgetSelected(SelectionEvent e) {
		Object o = e.getSource();
		if (o == button_ok) {
			try {
				writeToMonitor();
				modified = true;
				shell.dispose();
			} catch (Exception x) {
//				error_label.setText(EditorPlugin.getString("ERROR_LABEL")+x.getMessage());
//				EditorPlugin.DBG.warning(EditorPlugin.getString("ERROR_LABEL")+x.getMessage());
//				error_img.setImage(EditorPlugin.img.getImage(ImageManager.IMG_ERROR));
//				main_panel.layout(true);
//				error_label.redraw();
//				error_img.redraw();
			}
		} else if (o == button_cancel) {
			shell.dispose();
		}
	}

	private void initEventHandling() {
		button_ok.addSelectionListener(this);
		button_cancel.addSelectionListener(this);
	}
	
	private void initGraphics() {
		main_panel = new Composite(shell,0);
		main_panel.setLayout(new GridLayout(2,true));
		
		String DEF_TEXT = "               ";
		
		int groupHints = SWT.SHADOW_ETCHED_IN;
		
//		error_img = new Label(main_panel,SWT.NONE);
//		error_label = new Label(main_panel,SWT.NONE);
//		error_label.setText(DEF_TEXT);
		
		//Trigger config
		trigger_panel = new AlertTableMultiPanel(main_panel,monitor.trigger_actions,EditorPlugin.getString("TRIGGER_DESCRIPTION"));
		trigger_panel.setLayoutData(GData.getGridData(true,true,-1,-1,1,1,GridData.FILL,GridData.FILL));

		//Reset config
		reset_panel = new AlertTableMultiPanel(main_panel,monitor.reset_actions,EditorPlugin.getString("RESET_DESCRIPTION"));
		reset_panel.setLayoutData(GData.getGridData(true,true,-1,-1,1,1,GridData.FILL,GridData.FILL));

		//button panel	
		button_panel = new Composite(main_panel,SWT.NONE);
		button_panel.setLayoutData(GData.getGridData(true,false,-1,-1,2,1,GridData.FILL,GridData.END));
		button_panel.setLayout(new GridLayout(1,true));
		
			Composite bptmp = new Composite(button_panel,0);
			bptmp.setLayoutData(GData.getGridData(false,false,-1,-1,1,1,GridData.CENTER,GridData.CENTER));
			bptmp.setLayout(new GridLayout(2,true));
		
			button_ok = new Button(bptmp,SWT.PUSH);
			button_ok.setLayoutData(GData.getGridData(false,false,-1,-1,1,1,GridData.FILL,GridData.CENTER));
			button_ok.setText(EditorPlugin.getString("OK"));
//			button_ok.setLayoutData(GData.getGridData(true,false,-1,-1,1,1,GridData.END,GridData.CENTER));
			
			button_cancel = new Button(bptmp,SWT.PUSH);
			button_cancel.setLayoutData(GData.getGridData(false,false,-1,-1,1,1,GridData.FILL,GridData.CENTER));
			button_cancel.setText(EditorPlugin.getString("CANCEL"));
//			button_cancel.setLayoutData(GData.getGridData(true,false,-1,-1,1,1,GridData.BEGINNING,GridData.CENTER));
		
	}
	
	public Alert getMonitor() {
		return monitor;
	}
	
	private int getProviderIndex(String name) {
		String[] provider_names = AlertRegistry.getProviderNames();
		for (int i = 0; i < provider_names.length; i++) {
			if (name.equals(provider_names[i])) {
				return i;
			}
		}
		return 0;
	}

	private void writeToMonitor() throws InvalidDataException {
		try {
			monitor.trigger_actions = trigger_panel.getConfiguredActions();
			monitor.reset_actions = reset_panel.getConfiguredActions();
		} catch (NullPointerException e) {
			EditorPlugin.DBG.error("NullPointer on alert table dialog",e);
		} catch (SWTException e) {
		}
	}
	
}