/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.statistical.ui.editor.internal;

import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class GraphTableDialogCellEditor extends DialogCellEditor {

public GraphTableDialogCellEditor(Composite parent) {
	this(parent, SWT.NONE);
}
public GraphTableDialogCellEditor(Composite parent, int style) {
	super(parent, style);
}

protected Object openDialogBox(Control cellEditorWindow) {
	GraphTableDialog dialog = new GraphTableDialog(cellEditorWindow.getShell());
	dialog.setGraph(((GraphTable.GraphElement)getValue()).graph);
	((GraphTable.GraphElement)getValue()).readFromGraph();
	return dialog.open();
}
}