/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.statistical.ui.editor.internal;

import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class ImageRegistryProvider {

	static class NewImageRegistry implements Runnable {
		ImageRegistry imageRegistry;
		public void run() {
			Display display = PlatformUI.getWorkbench().getDisplay();
			imageRegistry = new ImageRegistry(display);
		}
	}	
	
	public static ImageRegistry createImageRegistry() {
		Display display = PlatformUI.getWorkbench().getDisplay();
		if (display == null) display = Display.getCurrent();
		if (display == null) display = Display.getDefault();
		NewImageRegistry tmp = new NewImageRegistry();
		display.syncExec(tmp);
		return tmp.imageRegistry;
	}
}