/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.statistical.ui.monitoractions.internal.cbe;

import java.text.SimpleDateFormat;

import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.model.statistical.SDDescriptor;
import org.eclipse.hyades.model.statistical.SDSnapshotObservation;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;
import org.eclipse.hyades.models.cbe.CBEComponentIdentification;
import org.eclipse.hyades.models.cbe.CBEFactory;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.statistical.ui.EditorPlugin;
import org.eclipse.hyades.statistical.ui.widgets.alert.internal.AlertAction;
import org.eclipse.hyades.statistical.ui.widgets.alert.internal.AlertActionControl;
import org.eclipse.swt.widgets.Composite;

public class CBEAlertAction implements AlertAction {

	public static final short SEVERITY_INFO = 10;
	public static final short SEVERITY_WARNING = 30;
	public static final short SEVERITY_MINOR_ERROR = 40;
	public static final short SEVERITY_FATAL_ERROR = 60;
	
	CBEFactory factory = CBEFactory.eINSTANCE;
	
	boolean trigger;
	String name;
	double value;
	double time;
	SDSnapshotObservation obs;
	
	static SimpleDateFormat sdf = new SimpleDateFormat();

	public AlertActionControl getControl(Composite c) {
		return new CBEControl(c,this);
	}
	
	public String getDescription() {
		return EditorPlugin.getString("ALERT_ACTION_NAME_CBE");
	}
	
	public String getProviderName() {
		return EditorPlugin.getString("ALERT_ACTION_NAME_CBE");
	}
	public void setInformation(String name, SDSnapshotObservation obs, double value, double time, boolean trigger) {
		this.name = name;
		this.value = value;
		this.time = time;
		this.trigger = trigger;
		this.obs = obs;
	}
	public void run() {
		try {
			SDDescriptor des = obs.getMemberDescriptor();
			TRCAgent agent = des.getAgent();
			while (agent == null) {
				des = des.getParent();
				agent = des.getAgent();
			}
			
			EList cbelog = agent.getDefaultEvents();
			
			CBEComponentIdentification sourceID = null;
			CBEComponentIdentification repID = null;
			String idtype = "Application";
			String sourceid = EditorPlugin.getString("ALERT_ACTION_SOURCEID");
			String sourcesubid = name;
			
			String message;
			if (trigger) {
				message = EditorPlugin.getString("ALERT_ALERT")+" "+name+" "+EditorPlugin.getString("ALERT_TRIGGERED_AT")+" "+value;
			} else {
				message = EditorPlugin.getString("ALERT_ALERT")+" "+name+" "+EditorPlugin.getString("ALERT_RESET_AT")+" "+value;
			}
			/*
			for (int i = 0; i < cbelog.size(); i++) {
				CBECommonBaseEvent event = (CBECommonBaseEvent)cbelog.get(i);
				CBEComponentIdentification id = event.getSourceComponentId();
				if (id.getComponentIdType().equals(idtype)
					&& id.getComponent().equals(sourceid)
					&& id.getSubComponent().equals(sourcesubid)) {
					sourceID = id;
					break;
				}
			}*/
			
			if (sourceID == null) {
				sourceID = factory.createCBEComponentIdentification();
				sourceID.setComponentIdType(idtype);
				sourceID.setComponent(sourceid);
				sourceID.setSubComponent(sourcesubid);
				sourceID.setLocationType("Application");
				sourceID.setLocation(sourceid);
			}
			if (repID == null) {
				repID = factory.createCBEComponentIdentification();
				repID.setComponentIdType(idtype);
				repID.setComponent(sourceid);
				repID.setSubComponent(sourcesubid);
				repID.setLocationType("Application");
				repID.setLocation(sourceid);
			}
			
			CBECommonBaseEvent event = factory.createCBECommonBaseEvent();
			event.setCreationTime(time * 1000.0d);
			event.setMsg(message);
			event.setSeverity(SEVERITY_WARNING);
			event.setSourceComponentId(sourceID);
			event.setReporterComponentId(repID);

			event.setAgent(agent);
			
		} catch (Exception e) {
			EditorPlugin.DBG.warning("error logging alert to Common Base Event log "+e);
		}
	}
	public Object clone() {
		CBEAlertAction action = new CBEAlertAction();
		action.name = name;
		action.value = value;
		action.time = time;
		action.trigger = trigger;
		action.obs = obs;
		return action;
	}
}

