/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.statistical.ui.variableloader.internal;

import org.eclipse.hyades.model.statistical.SDRepresentation;
import org.eclipse.hyades.model.statistical.SDSnapshotObservation;
import org.eclipse.swt.graphics.Image;


public interface SDMeasuredVariableRepresentation extends SDRepresentation {

public static final int NONE = -1;
public static final int INTEGER = 0;
public static final int LONG = 1;
public static final int FLOAT = 2;
public static final int DOUBLE = 3;
public static final int STRING = 4;

	public String getUniqueID();
	public String getName();
	public String getDescription();
	public Image getImage();
	public boolean hasBar();
	public int getMeasuredType();

	public void setMeasuredValue(long t, int i) throws ClassCastException;
	public void setMeasuredValue(long t, long i) throws ClassCastException;
	public void setMeasuredValue(long t, float i) throws ClassCastException;
	public void setMeasuredValue(long t, double i) throws ClassCastException;
	public void setMeasuredValue(long t, Object newval) throws ClassCastException;

	public Object getLastMeasuredValue();
	public long getLastMeasuredTime();
	
	public SDSnapshotObservation getMeasuredObservation();
}