/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.statistical.ui.variableloader.internal;

import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.model.statistical.SDDescriptor;
import org.eclipse.hyades.model.statistical.SDSampleWindow;
import org.eclipse.hyades.model.statistical.SDView;
import org.eclipse.hyades.model.statistical.StatisticalFactory;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.swt.graphics.Image;

public class SDVariableLoader {
	
StatisticalFactory factory = StatisticalFactory.eINSTANCE;
SDDescriptor root;
SDSampleWindow window;
	
	public SDVariableLoader(SDDescriptor model_root) {
		this.root = model_root;

		window = getOrCreateView(root.getAgent());
	}

	public SDVariableLoader(TRCAgent agent, String root_name) {
		root = factory.createSDDescriptor();
		root.setName(root_name);
		root.setAgent(agent);

		window = getOrCreateView(root.getAgent());
	}

	public SDDescriptor getModelRoot() {
		return root;
	}

	private SDSampleWindow getOrCreateView(TRCAgent trcagent) {

		SDView view = (SDView)trcagent.getView();

		//create a view if none exists
		if (view == null) {
			view = factory.createSDView();
			view.setAgent(trcagent);
			view.setName("view");
		}
		
		//create a sample window if none exists
		if (view.eContents().size() == 0) {
			SDSampleWindow window = factory.createSDSampleWindow();
			window.setView(view);
			
			return window;
		}

		return (SDSampleWindow)view.eContents().get(0);
	}
	
	public SDMeasuredVariableRepresentation createSDMeasuredVariable(
								String unique_varid, 
								String varname, 
								String vardesc,
								Image image,
								boolean has_bar, 
								int vartype, 
								String ownerid, 
								String ownerparent) {
		SDDescriptor vardescriptor = getDescriptor(ownerid,ownerparent);
		if (vardescriptor == null) {
			vardescriptor = createDescriptor(ownerid,ownerparent);	
		}
		
		SDMeasuredVariable variable = new SDMeasuredVariable( unique_varid, varname, vardesc, image, has_bar, vartype, vardescriptor, window);

		return variable;
	}

	public SDModifiableVariableRepresentation createSDModifiableVariable(
								String unique_varid, 
								String varname, 
								String vardesc, 
								Image image,
								boolean has_bar,
								int measured_vartype, 
								int modifier_vartype, 
								String ownerid, 
								String ownerparent, 
								SDVariableModifierProxy modifier,
								double minbound, 
								double maxbound) {
		SDDescriptor vardescriptor = (SDDescriptor)getDescriptor(ownerid,ownerparent);
		if (vardescriptor == null) {
			vardescriptor = createDescriptor(ownerid,ownerparent);	
		}
		
		SDModifiableVariable variable = new SDModifiableVariable( unique_varid, varname, vardesc, image, has_bar, measured_vartype, modifier_vartype, vardescriptor, modifier, minbound, maxbound, window);

		return variable;
	}
	
	private SDDescriptor getDescriptor(String id, String parentid) {
		return getDescriptor(root,id,parentid,root.getName().equals(parentid));	
	}

	private SDDescriptor getDescriptor(SDDescriptor descriptor, String id, String parentid, boolean descriptor_is_parent) {
		EList children = descriptor.getChildren();
		for (int i = 0; i < children.size(); i++) {
			SDDescriptor child = (SDDescriptor)children.get(i);
			String childname = child.getName();

			if (descriptor_is_parent && child.getName().equals(id)) {
				return child;
			}

			child = getDescriptor(child,id,parentid,child.getName().equals(parentid));
			
			if (child != null) return child;
		}
		
		return null;
	}

	private SDDescriptor createDescriptor(String id, String parentid) {
		SDDescriptor desc = createDescriptor(root,id,parentid);
		
		//couldnt find the parent
		if (desc == null) {
			SDDescriptor parent = factory.createSDDescriptor();

			parent.setParent(root);
			parent.setName(parentid);
			
			SDDescriptor child = factory.createSDDescriptor();
			child.setParent(parent);
			child.setName(id);
			
			return child;
		} 
		
		return desc;
	}

	private SDDescriptor createDescriptor(SDDescriptor descriptor, String id, String parentid) {
		if (descriptor.getName().equals(parentid)) {
			SDDescriptor child = factory.createSDDescriptor();
			child.setParent(descriptor);
			child.setName(id);
			return child;
		} else {
			
			EList children = descriptor.getChildren();
			for (int i = 0; i < children.size(); i++) {
				SDDescriptor child = (SDDescriptor)children.get(i);
				SDDescriptor mchild = createDescriptor(child,id,parentid);
				if (mchild != null) return mchild;
			}
			
		}
		
		return null;			
	}
}