/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.statistical.ui.variableloader.internal;

/**
 * This is used by the SDModifiableVariable class to modify the associated
 * variable.
 *
 */
public interface SDVariableModifierProxy {
	
	public void requestValue(String unique_id, int i) throws ClassCastException;
	public void requestValue(String unique_id, long i) throws ClassCastException;
	public void requestValue(String unique_id, float i) throws ClassCastException;
	public void requestValue(String unique_id, double i) throws ClassCastException;
	public void requestValue(String unique_id, Object newval) throws ClassCastException;
	
}