/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.statistical.ui.widgets.grapher.internal;

public class ThicknessHighlighter implements GraphHighlighter {

int thickness;	
int new_thickness = 6;

	public ThicknessHighlighter() {
	}
	
	public ThicknessHighlighter(int highlighted_thickness) {
		this.new_thickness = highlighted_thickness;
	}

	public void setHighlight(Graph g) {
		thickness = g.getLineWidth();
		if (thickness >= new_thickness) {
			g.setLineWidth(new_thickness+4);
		} else {
			g.setLineWidth(new_thickness);
		}
	}
	public void unsetHighlight(Graph g) {
		g.setLineWidth(thickness);
	}	
	
}