/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal;

import java.util.Vector;

import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;

public class ZoomControlBarsCollection
{
	ZoomSlider slider;
	
	double max, min;
	    
	Vector bars = new Vector();
	    
	boolean selected;
	
	boolean primed;
	
	boolean moved;
	    
    public ZoomControlBarsCollection(ZoomSlider slider)
    {
        this.slider = slider;
    }    
        
	public void add(ZoomControlBar bar)
	{
        if (bar != null)
        {
            if (!bars.contains(bar))
            {
	            bars.addElement(bar);
	        }
	    }    
	}
	    
	public void remove(ZoomControlBar bar)
	{
	    if (bar != null)
	    {
	        if (bars.contains(bar))
	        {
	            bars.removeElement(bar);
	        }
	    }    
	    selected = false;
	}
	
	public boolean hasBars()
	{
	    return !(bars.isEmpty());
	}
	
	public boolean isSelected()
	{
	    return selected;
	}
	
	public boolean isPrimed()
	{
	    return primed;
	}
	    
	public void paint(Image buffer, GC gBuffer, GC g, boolean indicatorsChanged)
	{
	    if (!selected)
	    {
	        for (int i=0; i<bars.size(); i++)
	        {
	            ((ZoomControlBar)(bars.elementAt(i))).paint(gBuffer);
	        }
	        
	        g.drawImage(buffer, 0, 0);
	    }
	    else
	    {
	        if (!primed || indicatorsChanged)
	        {
	            for (int i=0; i<bars.size() - 1; i++)
	            {
	                ((ZoomControlBar)(bars.elementAt(i))).paint(gBuffer);
	            }
	            
	            primed = true;
            }
	        
	        ((ZoomControlBar)(bars.elementAt(bars.size() - 1))).hide(buffer, gBuffer);
	            
	        g.drawImage(buffer, 0, 0);
	        
	        ((ZoomControlBar)(bars.elementAt(bars.size() - 1))).paint(g);
	    }
	}    

    public boolean mouseDown(MouseEvent event)
    {
        selected = false;
        primed = false;
        moved = false;
        
   	    ZoomControlBar bar = getZoomControlBarContaining(event.x, event.y);
  	        
  	    if (bar != null)
  	    {
            selected = true;
            
  	        bars.removeElement(bar);
              	        
  	        bars.addElement(bar);
  	            
            if (event.button == 1)
            {
                slider.updateScale();
                
  	            slider.redraw();
  	            
  	            primed = false;
  	        }

  	        return true;
  	    }
  	    return false;
  	}
  	    
  	public boolean mouseUp(MouseEvent event)
  	{
  	    if (selected)
  	    {
  	        ZoomControlBar last = (ZoomControlBar)(bars.elementAt(bars.size() - 1));
  	        
  	        last.sprayZoomControlBarEvent(true);
  	        
  	        selected = false;
  	        
  	        primed = false;

            if (!moved)
            {
                int pix = (int)(slider.value2Pixel(last.getValue()));
                
                for (int i=bars.size() - 2; i >=0; i--)
                {
                    ZoomControlBar previous = (ZoomControlBar)(bars.elementAt(i));
                    
                    int prevPix = (int)(slider.value2Pixel(previous.getValue()));
                    
                    if (prevPix > pix - 3 && prevPix < pix + 3)
                    {
                        bars.removeElement(last);
                        
                        bars.insertElementAt(last, 0);
                        
                        bars.removeElement(previous);
                        
                        bars.addElement(previous);
                        
                        break;
                    }
                }
            }    

            moved = false;
            
  	        slider.redraw();
  	        
  	        return true;
  	    }
  	    
  	    return false;
  	}
  	
  	public boolean mouseMove(MouseEvent event)
  	{
  	    if (primed)
  	    {
  	        moved = true;
  	        
  	        ZoomControlBar bar = ((ZoomControlBar)(bars.elementAt(bars.size() - 1)));
  	        
  	        double oldValue = bar.getValue();
  	        
  	        if (slider.getOrientation() == ZoomSlider.VERTICAL)
  	        {
  	            bar.setValue(ZoomSliderUtilities.round(slider.pixel2Value(event.y), slider.getUnitIncrement()));
  	        }    
  	        else
  	        {
  	            bar.setValue(ZoomSliderUtilities.round(slider.pixel2Value(event.x), slider.getUnitIncrement()));
  	        }
  	        
  	        slider.redraw();
  	        
  	        if (oldValue != bar.getValue())
  	        {
  	        	bar.sprayZoomControlBarEvent(false);
  	        }
  	    }
  	    
  	    return false;
  	}

    public ZoomControlBar getZoomControlBarContaining(int x, int y)
	{
	    if (bars.size() > 0)
	    {
	        int i = bars.size() - 1;
    	        
	        while (i >= 0 && !((ZoomControlBar)(bars.elementAt(i))).inside(x, y))
	        {
	            i--;
	        }
    	        
	        if (i >= 0)
	        {
	            return (ZoomControlBar)(bars.elementAt(i));
	        }
	    }    
	        
	    return null;
	}
	
	public Vector getZoomControlBars()
	{
	    return bars;
	}
	
	public void dispose()
	{
		for (int i=0; i<bars.size() - 1; i++)
		{
		    ((ZoomControlBar)(bars.elementAt(i))).dispose();
		}
	}  
} 
