/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: Incident.java,v 1.5 2005/02/16 22:19:53 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.analysis.engine;

import org.eclipse.hyades.logging.events.cbe.impl.CommonBaseEventImpl;

public class Incident extends CommonBaseEventImpl {

    /**
     * Unique message identifier.
     */
    private String messageId = null;

    /**
     * Constructor for creating an empty <code>Incident</code>.
     */
    public Incident() {
    }

    /**
     * Constructor for creating an <code>Incident</code>
     * with the parameter unique message identifier.
     * 
     * @param messageId the unique message identifier
     */
    public Incident(String messageId) {
        this.messageId = messageId;
    }

    /**
     * Sets the unique message identifier.
     * 
     * @param messageId the unique message identifier
     * @see   #getMessageId()
     */
    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    /**
     * Gets the unique message identifier.
     * 
     * @return the unique message identifier
     * @see    #setMessageId(String)
     */
    public String getMessageId() {
        return messageId;
    }

    /**
     * Resets the <code>Incident</code> to a 'newed object' state.
     */
    public void reset() {
        init();
    }

    /**
     * Resets the <code>Incident</code> to a 'newed object' state.
     */
    public void init() {

        super.init();

        messageId = null;
    }
}