/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: HyadesSamplePlugin.java,v 1.7 2005/02/16 22:23:46 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.trace.sample;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.ui.internal.util.CoreUtil;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/**
 * Log Analyzer Samples Plugin class.  This class should not be used 
 * outside the context of Eclipse.
 * 
 * @author sleeloy
 * @since 0.2.0
 */
public class HyadesSamplePlugin extends AbstractUIPlugin	
{
	private static HyadesSamplePlugin instance;
	public static final String PLUGIN_ID = "org.eclipse.hyades.trace.sample"; //$NON-NLS-1$
	private ResourceBundle fResourceBundle;
	

	/**
	 * Constructor for HyadesUIPlugin
	 * @param descriptor
	 */
	public HyadesSamplePlugin()
	{
		instance = this;
	}
	
	/**
	 * Returns the instance of this class created by the eclipse framework.
	 * @return HyadesUIPlugin
	 */
	public static HyadesSamplePlugin getInstance()
	{
		return instance;
	}
	
	/**
	 * @see org.osgi.framework.BundleActivator#stop(org.osgi.framework.BundleContext)
	 */
	public void stop(BundleContext context) throws Exception {
		super.stop(context);
		instance = null;
		fResourceBundle = null;
	}
	
	/**
	 * Returns this plugin's id.
	 * @return String
	 */
	public static String getID()
	{
		return PLUGIN_ID;
	}

	/* (non-Javadoc)
	 * @see org.osgi.framework.BundleActivator#start(org.osgi.framework.BundleContext)
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
	}

	/**
	 * Logs an error described by a throwable.
	 * 
	 * <p>This method should be used whenever a class in this plugin
	 * has to log an error since it adheres to the global logging
	 * strategy.
	 * 
	 * @param throwable
	 */
	public static void logError(Throwable throwable)
	{
		logError(CoreUtil.getStackTrace(throwable));
	}
	
	/**
	 * Logs an error described by a text.
	 * 
	 * <p>This method should be whenever a class in this plugin
	 * has to log an error since it adheres to the global logging
	 * strategy.
	 * 
	 * @param text
	 */
	public static void logError(String text)
	{
		System.err.println("***** HyadesUIPlugin.logError");
		System.err.println(text);
	}
	
	/**
	 * Logs an information described by a text.
	 * 
	 * <p>This method should be whenever a class in this plugin
	 * has to log an information since it adheres to the global logging
	 * strategy.
	 * 
	 * @param text
	 */
	public static void logInfo(String text)
	{
		System.out.println("***** HyadesUIPlugin.logInfo");
		System.out.println(text);
	}
	

	/**
	 * Returns the resource bundle used by this plugin.
	 * 
	 * <p>IMPORTANT: Don't use this method to retrieve values from the
	 * resource bundle.  For this purpose use the static <code>getString()</code> 
	 * defined in this class.
	 * 
	 * <p>This method is provided so this resource bundle can
	 * be used as the parent of another resource bundle.
	 * 
	 * @return ResourceBundle
	 */
	public ResourceBundle getResourceBundle()
	{
		if(fResourceBundle == null)
		{
			try {
				fResourceBundle = Platform.getResourceBundle(Platform.getBundle(PLUGIN_ID));
			} catch (MissingResourceException e) {
				e.printStackTrace();
				fResourceBundle = null;
			}
		}
		
		return fResourceBundle;
	}

	/**
	 * Returns the "plugin.properties" file's value associate to a given key.
	 * @param key
	 * @return String
	 * @throws java.util.MissingResourceException if the key is not in the file
	 * @throws NullPointerException if key is null
	 */
	public static String getString(String key)
	throws NullPointerException, MissingResourceException
	{
		return getInstance().getResourceBundle().getString(key);
	}
	
	public void log(IStatus status) {
		getLog().log(status);
	}
	
	public void log(Throwable e) {
		log(new Status(IStatus.ERROR, PLUGIN_ID, IStatus.ERROR, "Error", e)); //$NON-NLS-1$
	}
	
}
