/********************************************************************** 
 * Copyright (c) 2005 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: JavaAdapter.java,v 1.3 2005/05/20 21:38:57 sschneid Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/

package org.eclipse.hyades.automation.client.adapters.java;

import java.util.Properties;

import org.eclipse.hyades.automation.client.AutomationClient;
import org.eclipse.hyades.automation.core.Service;

/**
 * @author Scott E. Schneider
 * 
 * The Java adapter provides a front-end to external Java code that requires the
 * automation of published services. This Java adapter is mainly a pass- through
 * adapeter to the underlying launcher lightweight automation component since
 * the launcher is already exposed in Java for client adapter use. It is still
 * good practice to use this adapter from the Java-side instead of using the
 * automation launcher class directly.
 * 
 * @provisional
 */
public class JavaAdapter {

    /**
     * The automation client to use to execute the automation command
     */
    private AutomationClient client;

    /**
     * Constructs the java adapter for use by java code to execute automation
     * commands
     * 
     * @param root
     *            the root of the eclipse to use (the eclipse home directory)
     */
    public JavaAdapter(String root) {
        this.client = AutomationClient.Factory.getInstance().createAutomationClient(root);
    }

    /**
     * Executes the service specified by the identifier with the given
     * properties
     * 
     * @param identifier
     *            the service identifier
     * @param properties
     *            the properties that comprise the service state
     * @return the return value from the service
     */
    public Object execute(String identifier, Properties properties) {
        Service service = client.request(identifier);
        service.configure(properties);
        Object value = client.execute(service);
        return value;
    }

}