/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SDBRuntime.java,v 1.7 2005/02/16 22:21:25 qiyanli Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.internal.sdb;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Runtime</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * A runtime instance typically represents a product or a system, such as a 
 * Relational Database or a web server.
 * 
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.internal.sdb.SDBRuntime#getId <em>Id</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.internal.sdb.SDBRuntime#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.internal.sdb.SDBRuntime#getSymptomUrl <em>Symptom Url</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.internal.sdb.SDBRuntime#getLocalExternalFileLocation <em>Local External File Location</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.internal.sdb.SDBRuntime#getDescription <em>Description</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.internal.sdb.SDBRuntime#getSymptoms <em>Symptoms</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.internal.sdb.SDBRuntime#getSolutions <em>Solutions</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.internal.sdb.SDBRuntime#getDirectives <em>Directives</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.models.internal.sdb.SDBPackage#getSDBRuntime()
 * @model 
 * @generated
 */
public interface SDBRuntime extends EObject{
	/**
	 * Returns the value of the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Id</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Each runtime is uniquely identified by this value.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Id</em>' attribute.
	 * @see #setId(String)
	 * @see org.eclipse.hyades.models.internal.sdb.SDBPackage#getSDBRuntime_Id()
	 * @model 
	 * @generated
	 */
	String getId();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.internal.sdb.SDBRuntime#getId <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Id</em>' attribute.
	 * @see #getId()
	 * @generated
	 */
	void setId(String value);

	/**
	 * Returns the value of the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Name</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The name hold a short human readable title for the runtime. For example "MyRDB product V6"
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Name</em>' attribute.
	 * @see #setName(String)
	 * @see org.eclipse.hyades.models.internal.sdb.SDBPackage#getSDBRuntime_Name()
	 * @model 
	 * @generated
	 */
	String getName();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.internal.sdb.SDBRuntime#getName <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Name</em>' attribute.
	 * @see #getName()
	 * @generated
	 */
	void setName(String value);

	/**
	 * Returns the value of the '<em><b>Symptom Url</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Symptom Url</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The symptom data base can have a URL associated with it to identify where it was downloaded from. This is a typical model to support refreshing of the DB.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Symptom Url</em>' attribute.
	 * @see #setSymptomUrl(String)
	 * @see org.eclipse.hyades.models.internal.sdb.SDBPackage#getSDBRuntime_SymptomUrl()
	 * @model 
	 * @generated
	 */
	String getSymptomUrl();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.internal.sdb.SDBRuntime#getSymptomUrl <em>Symptom Url</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Symptom Url</em>' attribute.
	 * @see #getSymptomUrl()
	 * @generated
	 */
	void setSymptomUrl(String value);

	/**
	 * Returns the value of the '<em><b>Local External File Location</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Local External File Location</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * A symptom DB for a given product can be provided as a local file, and this property captures the location as a convienence for refreshing.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Local External File Location</em>' attribute.
	 * @see #setLocalExternalFileLocation(String)
	 * @see org.eclipse.hyades.models.internal.sdb.SDBPackage#getSDBRuntime_LocalExternalFileLocation()
	 * @model 
	 * @generated
	 */
	String getLocalExternalFileLocation();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.internal.sdb.SDBRuntime#getLocalExternalFileLocation <em>Local External File Location</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Local External File Location</em>' attribute.
	 * @see #getLocalExternalFileLocation()
	 * @generated
	 */
	void setLocalExternalFileLocation(String value);

	/**
	 * Returns the value of the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Description</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * A description of the runtime represented. This is humuan readable information and is determined by the runtime provider.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Description</em>' attribute.
	 * @see #setDescription(String)
	 * @see org.eclipse.hyades.models.internal.sdb.SDBPackage#getSDBRuntime_Description()
	 * @model 
	 * @generated
	 */
	String getDescription();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.internal.sdb.SDBRuntime#getDescription <em>Description</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Description</em>' attribute.
	 * @see #getDescription()
	 * @generated
	 */
	void setDescription(String value);

	/**
	 * Returns the value of the '<em><b>Symptoms</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.internal.sdb.SDBSymptom}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Symptoms</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Symptoms</em>' containment reference list.
	 * @see org.eclipse.hyades.models.internal.sdb.SDBPackage#getSDBRuntime_Symptoms()
	 * @model type="org.eclipse.hyades.models.internal.sdb.SDBSymptom" containment="true"
	 * @generated
	 */
	EList getSymptoms();

	/**
	 * Returns the value of the '<em><b>Solutions</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.internal.sdb.SDBSolution}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Solutions</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Solutions</em>' containment reference list.
	 * @see org.eclipse.hyades.models.internal.sdb.SDBPackage#getSDBRuntime_Solutions()
	 * @model type="org.eclipse.hyades.models.internal.sdb.SDBSolution" containment="true"
	 * @generated
	 */
	EList getSolutions();

	/**
	 * Returns the value of the '<em><b>Directives</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.internal.sdb.SDBDirective}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Directives</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Directives</em>' containment reference list.
	 * @see org.eclipse.hyades.models.internal.sdb.SDBPackage#getSDBRuntime_Directives()
	 * @model type="org.eclipse.hyades.models.internal.sdb.SDBDirective" containment="true"
	 * @generated
	 */
	EList getDirectives();

} // SDBRuntime
