/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: StackTester.java,v 1.4 2005/02/16 22:20:15 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.tests.collection.correlation;

import org.eclipse.hyades.collection.correlation.Stack;

/**
 * This is the tester class for {@link org.eclipse.hyades.collection.correlation.Stack Stack}.
 * 
 * @author Qiyan Li
 */
public class StackTester {

    public static void main(String[] args) {
        Stack stack;

        System.err.println("#1: create a stack...");
        System.err.println("Stack(1, 1): " + (stack = new Stack(1, 1)) + "\n");
        
        System.err.println("#2: push(n) with and without overflows and peek() with and without underflows...");
        for (int i = 0; i < 5; i++) {
            try {
                System.err.print("peek(): ");
                System.err.println(((Integer) stack.peek()).intValue());
            } catch (Exception e) {
                e.printStackTrace();
            }
            
            Integer n = new Integer(i);
            stack.push(n);
            System.err.println("push(" + i + "): " + n);
        }
        System.err.println();
        
        System.err.println("#3: peek(n) with and without underflows...");
        for (int i = -3; i < 7; i++) {
            try {
                System.err.print("peek(" + i + "): ");
                System.err.println(((Integer) stack.peek(i)).intValue());
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        System.err.println();
        
        System.err.println("#4: pop() with and without underflows...");
        for (int i = 0; i < 6; i++) {
            try {
                System.err.print("pop(): ");
                System.err.println(((Integer) stack.pop()).intValue());
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        System.err.println();
        
        System.err.println("#5: push(n) with and without overflows and peek() with and without underflows," +
                           " same as #2, but after emptying the stack...");
        for (int i = 0; i < 5; i++) {
            try {
                System.err.print("peek(): ");
                System.err.println(((Integer) stack.peek()).intValue());
            } catch (Exception e) {
                e.printStackTrace();
            }
            
            Integer n = new Integer(i);
            stack.push(n);
            System.err.println("push(" + i + "): " + n);
        }
        System.err.println();

        System.err.println("EOT");
    }
}
