/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: GoToMessageReturnOnDistinctPageAction.java,v 1.1 2005/03/24 22:40:27 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.trace.actions.internal;

import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.uml2sd.trace.loaders.TraceInteractions;
import org.eclipse.hyades.uml2sd.trace.selection.IEObjectSelection;
import org.eclipse.hyades.uml2sd.ui.SDViewerPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IWorkbenchPart;

/**
 * Action to go on associated message return that is on another page
 */
public class GoToMessageReturnOnDistinctPageAction extends TraceGraphNodeAction {
	
	/**
	 * @see org.eclipse.ui.IObjectActionDelegate#setActivePart(org.eclipse.jface.action.IAction, org.eclipse.ui.IWorkbenchPart)
	 */
	public void setActivePart(IAction action_, IWorkbenchPart targetPart_) {
		super.setActivePart(action_, targetPart_);
		action_.setText(SDViewerPlugin.getResourceString("POPUP_MENU_GO_TO_MESSAGE_RET")); //$NON-NLS-1$
		action_.setImageDescriptor(SDViewerPlugin.getResourceImage("show_image_maplist.gif")); //$NON-NLS-1$
	}

	public void run() {
		TraceInteractions.findInvocation((TRCMethodInvocation)((IEObjectSelection)graphNodes.get(0)).getEObject(), true);
	}

}
