/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TraceMessageExpandAction.java,v 1.4 2005/02/16 22:24:05 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.trace.actions.internal;

import org.eclipse.hyades.uml2sd.trace.loaders.TraceInteractions;

/**
 * Action delegate for 'Expand' on a message
 */
public class TraceMessageExpandAction extends TraceGraphNodeAction {

	/**
	 * @see org.eclipse.hyades.uml2sd.trace.actions.internal.TraceGraphNodeAction#run(org.eclipse.hyades.uml2sd.trace.loaders.TraceInteractions)
	 */
	public void run() {
		TraceInteractions.getInstance().expandCalledMessages(graphNodes);
	}
	
}
