/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ProcessInteractions.java,v 1.11 2005/03/18 15:27:04 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.trace.loaders;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.uml2sd.trace.TraceSDPlugin;

/**
 * This class aims to populate a Process Interaction UML2 Sequence Diagram.
 */
public class ProcessInteractions extends BaseLifelineLoader {
	
	/**
	 * Constructor
	 */
	public ProcessInteractions() {
		parent = new NodeInteractions();
	}
	
	/**
	 * @see org.eclipse.hyades.uml2sd.trace.loaders.ILifelineLoader#getLifelineEObjectFromMethodInvocation(org.eclipse.hyades.models.trace.TRCFullMethodInvocation)
	 */
	public EObject getLifelineEObjectFromMethodInvocation(
			TRCFullMethodInvocation mi) {
		return mi.getProcess(); // TRCProcess
	}
	
	/**
	 * @see org.eclipse.hyades.uml2sd.trace.loaders.ILifelineLoader#getLifeLineCategory(org.eclipse.emf.ecore.EObject)
	 */
	public int getLifeLineCategory(EObject to) {
		return TraceInteractions.CATEGORY_PROCESS;
	}
	
	/**
	 * @see org.eclipse.hyades.uml2sd.trace.loaders.ILifelineLoader#getLifeLineTitle(org.eclipse.emf.ecore.EObject, boolean)
	 */
	public String getLifeLineTitle(EObject to, boolean long_) {
		TRCProcess process = (TRCProcess)to;
		return process.getAgent().getAgentProxy().getProcessProxy().getName()+" [Pid "+process.getPid()+"]"; //$NON-NLS-1$ //$NON-NLS-2$
	}

	/**
	 * The runtimeId of agentProxy and the lifeline title
	 */
	public String getLifeLineId(EObject eo) {
		TRCAgentProxy ap;
		ap = ((TRCProcess)eo).getAgent().getAgentProxy();
		return ap.getRuntimeId()+"#"+getLifeLineTitle(eo, true); //$NON-NLS-1$
	}
	
	/**
	 * @see org.eclipse.hyades.uml2sd.trace.loaders.ILifelineLoader#getFinalTitleString()
	 */
	public String getFinalTitleString() {
		return TraceSDPlugin.getResourceString("STR_UML2SD_PROCESS_INTERACTION"); //$NON-NLS-1$
	}

	/**
	 * @see org.eclipse.hyades.uml2sd.trace.loaders.ILifelineLoader#getLifelineType(org.eclipse.emf.ecore.EObject)
	 */
	public String getLifelineType(EObject eObject) {
		return TraceSDPlugin.getResourceString("STR_PROCESS"); //$NON-NLS-1$;
	}

	/**
	 * @return a string carrying the lifeline type
	 */
	public String getLifelineTypeName() {
		return TraceSDPlugin.getResourceString("STR_PROCESS"); //$NON-NLS-1$;
	}

}
