/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: FilterQuery.java,v 1.3 2005/03/24 22:40:27 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.trace.loaders.internal;

import java.util.Iterator;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.models.hierarchy.extensions.BinaryExpression;
import org.eclipse.hyades.models.hierarchy.extensions.ExtensionsFactory;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalExpression;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleOperand;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.hierarchy.util.internal.SimpleSearchQueryEngine;

/**
 * This class is intended to build and execute the filter queries
 */
public class FilterQuery {
	
	public static boolean isMatchingFilter(EObject source, SimpleSearchQuery filter) {

		filter.getSources().clear();
		filter.getSources().add(EcoreUtil.getURI(source).toString());
		
		filter.getOutputElements().clear();
		SimpleOperand outputElement = ExtensionsFactory.eINSTANCE.createSimpleOperand();
		outputElement.setType(source.eClass());
		filter.getOutputElements().add(outputElement);

		//System.err.println("Checking for "+source+" on query:");
		//System.err.println(printExpr(filter.getWhereExpression()));
		
		SimpleSearchQueryEngine engine = new SimpleSearchQueryEngine(filter, source.eResource().getResourceSet());
		SimpleSearchQueryEngine.SimpleSearchQueryEvaluator evaluator = engine.new SimpleSearchQueryEvaluator();
		SimpleSearchQueryEngine.EvalResult result = evaluator.prepareEvalResult();
		result.eval(source);
		//System.err.println(result.isComplete()+" "+result.booleanValue());
		
		return result.isComplete() ? result.booleanValue() != null ? result.booleanValue().booleanValue() : true : true;

//		QueryResult result = engine.executeQuery(filter, source.eResource().getResourceSet(),Collections.EMPTY_LIST);
//		if (result != null && result.getResultEntries().size() > 0) {
//			System.err.println(" result.getResultEntries().size()="+result.getResultEntries().size());
//			List list = (List)((ResultEntry)result.getResultEntries().get(0)).getValue();
//			System.err.println(" list="+list);
//			if (list.size() > 0) {
//				System.err.println(" true "+list.size());
//				return true;
//			}
//		}
//		System.err.println(" false");
//		return false;
	}
	
	private static String printExpr(Object expr) {
		String result = ""; //$NON-NLS-1$
		if (expr instanceof BinaryExpression) {
			result += printBinaryExpression((BinaryExpression)expr);
		} else if (expr instanceof LogicalExpression) {
			result += printLogicalExpression((LogicalExpression)expr);
		} else if (expr instanceof SimpleOperand) {
			result += printSimpleOperand((SimpleOperand)expr);
		} else {
			result += expr.toString();
		}
		return result;
	}

	private static String printBinaryExpression(BinaryExpression expr) {
		String result = "[BE: "; //$NON-NLS-1$
		result += printExpr(expr.getLeftOperand());
		result += " "+expr.getOperator().getName()+"("; //$NON-NLS-1$ //$NON-NLS-2$
		for (Iterator i = expr.getRightOperands().iterator(); i.hasNext(); ) {
			result += ","+printExpr(i.next()); //$NON-NLS-1$
		}
		result += ")]"; //$NON-NLS-1$
		return result;
	}

	private static String printLogicalExpression(LogicalExpression expr) {
		String result = "[LE: "; //$NON-NLS-1$
		result += expr.getOperator().getName()+"("; //$NON-NLS-1$
		for (Iterator i = expr.getArguments().iterator(); i.hasNext(); ) {
			result += ","+printExpr(i.next()); //$NON-NLS-1$
		}
		result += ")]"; //$NON-NLS-1$
		return result;
	}

	private static String printSimpleOperand(SimpleOperand operand) {
		if (operand.getRawValue() != null) {
			return operand.getRawValue();
		}
		if (operand.getFeature() != null) {
			return operand.getFeature().getEContainingClass().getName()+"."+operand.getFeature().getName(); //$NON-NLS-1$
		}
		return "x"; //$NON-NLS-1$
	}

}
