/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TraceProcess.java,v 1.5 2005/03/24 22:40:27 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.trace.loaders.internal;

import java.util.Iterator;

import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.uml2sd.trace.util.TIUtils;


/**
 * A way to iterate on method invocations of a TRCProcess 
 */
public class TraceProcess {
	
	private TRCProcess process;
	private Iterator iterator;
	private double startTime, currentRelativeTime;
	private TRCFullMethodInvocation methodInvocation;
	
	/**
	 * @param process_
	 */
	public TraceProcess(TRCProcess process_) {
		process = process_;
	}
	
	/**
	 * 
	 */
	public void init() {
		iterator = process.getInvocations().iterator();
		startTime = TIUtils.getAbsoluteEntryTime(process);
		nextInvocation(); // pump up for the first one (this first call to nextInvocation returns null)

	}

	/**
	 * @return
	 */
	public TRCProcess getProcess() {
		return process;
	}
	
	public boolean hasNext() {
		return methodInvocation != null;
	}
	
	/**
	 * @return
	 */
	public double getCurrentTime() {
		return TIUtils.getAbsoluteEntryTime(process.getAgent()) + currentRelativeTime;
	}
	
	/**
	 * @return
	 */
	public double getStartTime() {
		return startTime;
	}
	
	/**
	 * @return
	 */
	public TRCFullMethodInvocation nextInvocation() {
		TRCFullMethodInvocation previous = methodInvocation;
		if (iterator.hasNext()) {
			methodInvocation = (TRCFullMethodInvocation)iterator.next();
			currentRelativeTime = methodInvocation.getEntryTime();
		} else {
			methodInvocation = null;
			currentRelativeTime = process.getLastEventTime();
		}
		return previous; // on first call it's null
	}
}
