/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TraceProcesses.java,v 1.8 2005/03/24 22:40:27 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.trace.loaders.internal;

import java.util.ArrayList;
import java.util.Iterator;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.uml2sd.trace.TraceSDPlugin;
import org.eclipse.hyades.uml2sd.trace.util.TIUtils;

/**
 * List of processes being displayed in a trace sequence diagram
 */
public class TraceProcesses extends ArrayList {
	
	private ArrayList sortedProcesses;
	
	/**
	 * @return
	 */
	public TRCFullMethodInvocation consumeMethodInvocation() {
		if (sortedProcesses.isEmpty()) {
			return null;
		}
		TraceProcess tp = (TraceProcess)sortedProcesses.get(0);
		TRCFullMethodInvocation ret = tp.nextInvocation();
		if (tp.hasNext()) {
			if (sortedProcesses.size() > 1 && tp.getCurrentTime() > ((TraceProcess)sortedProcesses.get(1)).getCurrentTime()) {
				// let's give him the right place later in the sorted list of processes
				sortedProcesses.remove(tp);
				sortProcess(tp);
			} // else it's still the earlier one in the list
		} else {
			// this one is consumed
			sortedProcesses.remove(tp);
		}
		return ret;
	}
	
	public double getStartTime() {
		if (sortedProcesses.isEmpty()) {
			return 0;
		}
		return ((TraceProcess)sortedProcesses.get(0)).getStartTime();
	}
	
	/**
	 * 
	 */
	public void init() {
		sortedProcesses = new ArrayList();
		for (Iterator i = iterator(); i.hasNext(); ) {
			TraceProcess p = (TraceProcess)i.next();
			p.init();
			sortProcess(p);
		}
	}
	
	/**
	 * @param p
	 */
	private void sortProcess(TraceProcess p) {
		double targetTime = p.getCurrentTime();
		for (int i = 0; i < sortedProcesses.size(); i++) {
			if (((TraceProcess)sortedProcesses.get(i)).getCurrentTime() > targetTime) {
				sortedProcesses.add(i, p);
				return;
			}
		}
		sortedProcesses.add(p);
	}
	
	public boolean contains(TRCProcess process) {
		for (int i = 0; i < size(); i++) {
			TraceProcess p = (TraceProcess)get(i);
			if (p.getProcess() == process) {
				return true;
			}
		}
		return false;
	}
	
	/**
	 * @param eObject
	 * @return
	 */
	public static TraceProcesses getTraceProcesses(EObject eObject, IProgressMonitor monitor) {
		TraceProcesses ret = new TraceProcesses();
		TIUtils.searchTRCProcesses(eObject, ret, monitor);
		if (ret.isEmpty()) {
			if (TraceSDPlugin.debugLoader) {
				TraceSDPlugin.debugTraceLoader("No processes to display"); //$NON-NLS-1$
			}
			return null;
		}
		if (TraceSDPlugin.debugLoader) {
			TraceSDPlugin.debugTraceLoader(ret.size()+" process(es) to display:"); //$NON-NLS-1$
			for (int i = 0; i < ret.size(); i++ ) {
				TraceSDPlugin.debugTraceLoader("  "+((TraceProcess)ret.get(i)).getProcess().getAgent().getAgentProxy().getProcessProxy().getName()); //$NON-NLS-1$
			}
		}
		return ret;
	}
	
}
