/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: HttpRecResourceBundle.java,v 1.4 2005/02/16 22:20:20 qiyanli Exp $
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.recorder.http.remote;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

import org.eclipse.hyades.test.common.util.BaseString;

public class HttpRecResourceBundle
{
	private static HttpRecResourceBundle instance;
	private ResourceBundle resourceBundle;

	private HttpRecResourceBundle()
	{
		try
		{
			resourceBundle = ResourceBundle.getBundle("httprecRunner");
		}
		catch(MissingResourceException e)
		{
			e.printStackTrace();
		}
	}

	public static HttpRecResourceBundle getInstance()
	{
		if (instance == null)
		{
			instance = new HttpRecResourceBundle();
		}

		return instance;
	}

	public ResourceBundle getResourceBundle()
	{
		return resourceBundle;
	}

	public String getString(String key) throws MissingResourceException
	{
		return resourceBundle.getString(key);
	}

	public String getString(String key, String[] args)
	{
		String value = getString(key);
		if (value == null)
			return null;

		for (int i = 0; i < args.length; i++)
			value = BaseString.replace(value, ("%" + (i + 1)), args[i]);

		return value;
	}
}
